/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.node;

import io.lucenia.painless.Location;
import io.lucenia.painless.node.AExpression;
import io.lucenia.painless.phase.UserTreeVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ECall
extends AExpression {
    private final AExpression prefixNode;
    private final String methodName;
    private final List<AExpression> argumentNodes;
    private final boolean isNullSafe;

    public ECall(int identifier, Location location, AExpression prefixNode, String methodName, List<AExpression> argumentNodes, boolean isNullSafe) {
        super(identifier, location);
        this.prefixNode = Objects.requireNonNull(prefixNode);
        this.methodName = Objects.requireNonNull(methodName);
        this.argumentNodes = Collections.unmodifiableList(Objects.requireNonNull(argumentNodes));
        this.isNullSafe = isNullSafe;
    }

    public AExpression getPrefixNode() {
        return this.prefixNode;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<AExpression> getArgumentNodes() {
        return this.argumentNodes;
    }

    public boolean isNullSafe() {
        return this.isNullSafe;
    }

    @Override
    public <Scope> void visit(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        userTreeVisitor.visitCall(this, scope);
    }

    @Override
    public <Scope> void visitChildren(UserTreeVisitor<Scope> userTreeVisitor, Scope scope) {
        this.prefixNode.visit(userTreeVisitor, scope);
        for (AExpression argumentNode : this.argumentNodes) {
            argumentNode.visit(userTreeVisitor, scope);
        }
    }
}

