/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.phase;

import io.lucenia.painless.lookup.PainlessLookup;
import io.lucenia.painless.node.SClass;
import io.lucenia.painless.node.SFunction;
import io.lucenia.painless.phase.UserTreeBaseVisitor;
import io.lucenia.painless.symbol.FunctionTable;
import io.lucenia.painless.symbol.ScriptScope;
import java.util.ArrayList;
import java.util.List;

public class DefaultSemanticHeaderPhase
extends UserTreeBaseVisitor<ScriptScope> {
    @Override
    public void visitClass(SClass userClassNode, ScriptScope scriptScope) {
        for (SFunction userFunctionNode : userClassNode.getFunctionNodes()) {
            this.visitFunction(userFunctionNode, scriptScope);
        }
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String returnCanonicalTypeName;
        String functionKey;
        String functionName = userFunctionNode.getFunctionName();
        List<String> canonicalTypeNameParameters = userFunctionNode.getCanonicalTypeNameParameters();
        List<String> parameterNames = userFunctionNode.getParameterNames();
        int parameterCount = canonicalTypeNameParameters.size();
        if (parameterCount != parameterNames.size()) {
            throw userFunctionNode.createError(new IllegalStateException("invalid function definition: parameter types size [" + canonicalTypeNameParameters.size() + "] is not equal to parameter names size [" + parameterNames.size() + "] for function [" + functionName + "]"));
        }
        FunctionTable functionTable = scriptScope.getFunctionTable();
        if (functionTable.getFunction(functionKey = FunctionTable.buildLocalFunctionKey(functionName, canonicalTypeNameParameters.size())) != null) {
            throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: found duplicate function [" + functionKey + "]."));
        }
        PainlessLookup painlessLookup = scriptScope.getPainlessLookup();
        Class<?> returnType = painlessLookup.canonicalTypeNameToType(returnCanonicalTypeName = userFunctionNode.getReturnCanonicalTypeName());
        if (returnType == null) {
            throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: return type [" + returnCanonicalTypeName + "] not found for function [" + functionKey + "]"));
        }
        ArrayList typeParameters = new ArrayList();
        for (String typeParameter : canonicalTypeNameParameters) {
            Class<?> paramType = painlessLookup.canonicalTypeNameToType(typeParameter);
            if (paramType == null) {
                throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: parameter type [" + typeParameter + "] not found for function [" + functionKey + "]"));
            }
            typeParameters.add(paramType);
        }
        functionTable.addFunction(functionName, returnType, typeParameters, userFunctionNode.isInternal(), userFunctionNode.isStatic());
    }
}

