/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.painless.phase;

import io.lucenia.painless.node.AExpression;
import io.lucenia.painless.node.EBrace;
import io.lucenia.painless.node.ECall;
import io.lucenia.painless.node.EDot;
import io.lucenia.painless.node.EString;
import io.lucenia.painless.node.ESymbol;
import io.lucenia.painless.phase.UserTreeBaseVisitor;
import io.lucenia.painless.symbol.Decorations;
import io.lucenia.painless.symbol.ScriptScope;
import java.util.List;

public class DocFieldsPhase
extends UserTreeBaseVisitor<ScriptScope> {
    @Override
    public void visitSymbol(ESymbol userSymbolNode, ScriptScope scriptScope) {
        if (userSymbolNode.getSymbol().equals("doc")) {
            scriptScope.setCondition(userSymbolNode, Decorations.IsDocument.class);
        }
    }

    @Override
    public void visitBrace(EBrace userBraceNode, ScriptScope scriptScope) {
        userBraceNode.getPrefixNode().visit(this, scriptScope);
        scriptScope.replicateCondition(userBraceNode.getPrefixNode(), userBraceNode.getIndexNode(), Decorations.IsDocument.class);
        userBraceNode.getIndexNode().visit(this, scriptScope);
    }

    @Override
    public void visitDot(EDot userDotNode, ScriptScope scriptScope) {
        AExpression prefixNode = userDotNode.getPrefixNode();
        prefixNode.visit(this, scriptScope);
        if (scriptScope.getCondition(prefixNode, Decorations.IsDocument.class)) {
            scriptScope.addDocField(userDotNode.getIndex());
        }
    }

    @Override
    public void visitCall(ECall userCallNode, ScriptScope scriptScope) {
        AExpression prefixNode = userCallNode.getPrefixNode();
        prefixNode.visit(this, scriptScope);
        List<AExpression> argumentNodes = userCallNode.getArgumentNodes();
        if (argumentNodes.size() != 1 || !userCallNode.getMethodName().equals("get")) {
            for (AExpression argumentNode : argumentNodes) {
                argumentNode.visit(this, scriptScope);
            }
        } else {
            AExpression argument = argumentNodes.get(0);
            scriptScope.replicateCondition(prefixNode, argument, Decorations.IsDocument.class);
            argument.visit(this, scriptScope);
        }
    }

    @Override
    public void visitString(EString userStringNode, ScriptScope scriptScope) {
        if (scriptScope.getCondition(userStringNode, Decorations.IsDocument.class)) {
            scriptScope.addDocField(userStringNode.getString());
        }
    }
}

