/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.configuration;

import io.skylite.SkyliteException;
import io.skylite.SkyliteTimeoutException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsResponse;
import io.skylite.core.action.admin.cluster.configuration.VotingConfigExclusionsHelper;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportAddVotingConfigExclusionsAction
extends TransportClusterManagerNodeAction<AddVotingConfigExclusionsRequest, AddVotingConfigExclusionsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAddVotingConfigExclusionsAction.class);
    private volatile int maxVotingConfigExclusions;

    @Inject
    public TransportAddVotingConfigExclusionsAction(Settings settings, ClusterSettings clusterSettings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/voting_config/add_exclusions", transportService, clusterService, threadPool, actionFilters, AddVotingConfigExclusionsRequest::new, indexNameExpressionResolver);
        this.maxVotingConfigExclusions = (Integer)AddVotingConfigExclusionsAction.MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(AddVotingConfigExclusionsAction.MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING, this::setMaxVotingConfigExclusions);
    }

    private void setMaxVotingConfigExclusions(int maxVotingConfigExclusions) {
        this.maxVotingConfigExclusions = maxVotingConfigExclusions;
    }

    protected String executor() {
        return "same";
    }

    protected AddVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new AddVotingConfigExclusionsResponse(in);
    }

    protected void clusterManagerOperation(final AddVotingConfigExclusionsRequest request, ClusterState state, final ActionListener<AddVotingConfigExclusionsResponse> listener) throws Exception {
        VotingConfigExclusionsHelper.resolveVotingConfigExclusionsAndCheckMaximum((AddVotingConfigExclusionsRequest)request, (ClusterState)state, (int)this.maxVotingConfigExclusions);
        this.clusterService.submitStateUpdateTask("add-voting-config-exclusions", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT){
            private Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions;

            public ClusterState execute(ClusterState currentState) {
                assert (this.resolvedExclusions == null) : this.resolvedExclusions;
                int finalMaxVotingConfigExclusions = TransportAddVotingConfigExclusionsAction.this.maxVotingConfigExclusions;
                this.resolvedExclusions = VotingConfigExclusionsHelper.resolveVotingConfigExclusionsAndCheckMaximum((AddVotingConfigExclusionsRequest)request, (ClusterState)currentState, (int)finalMaxVotingConfigExclusions);
                return VotingConfigExclusionsHelper.addExclusionAndGetState((ClusterState)currentState, this.resolvedExclusions, (int)finalMaxVotingConfigExclusions);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                ClusterStateObserver observer = new ClusterStateObserver(TransportAddVotingConfigExclusionsAction.this.clusterService, request.getTimeout(), logger, TransportAddVotingConfigExclusionsAction.this.threadPool.getThreadContext());
                Set excludedNodeIds = this.resolvedExclusions.stream().map(CoordinationMetadata.VotingConfigExclusion::getNodeId).collect(Collectors.toSet());
                Predicate<ClusterState> allNodesRemoved = clusterState -> {
                    Set votingConfigNodeIds = clusterState.getLastCommittedConfiguration().getNodeIds();
                    return excludedNodeIds.stream().noneMatch(votingConfigNodeIds::contains);
                };
                ClusterStateObserver.Listener clusterStateListener = new ClusterStateObserver.Listener(){

                    public void onNewClusterState(ClusterState state) {
                        listener.onResponse((Object)new AddVotingConfigExclusionsResponse());
                    }

                    public void onClusterServiceClose() {
                        listener.onFailure((Exception)new SkyliteException("cluster service closed while waiting for voting config exclusions " + String.valueOf(resolvedExclusions) + " to take effect", new Object[0]));
                    }

                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure((Exception)new SkyliteTimeoutException("timed out waiting for voting config exclusions " + String.valueOf(resolvedExclusions) + " to take effect", new Object[0]));
                    }
                };
                if (allNodesRemoved.test(newState)) {
                    clusterStateListener.onNewClusterState(newState);
                } else {
                    observer.waitForNextChange(clusterStateListener, allNodesRemoved);
                }
            }
        });
    }

    protected ClusterBlockException checkBlock(AddVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return AddVotingConfigExclusionsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAddVotingConfigExclusionsAction.class;
        }
    }
}

