/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.configuration;

import io.skylite.SkyliteException;
import io.skylite.SkyliteTimeoutException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.configuration.ClearVotingConfigExclusionsAction;
import io.skylite.core.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import io.skylite.core.action.admin.cluster.configuration.ClearVotingConfigExclusionsResponse;
import io.skylite.core.action.admin.cluster.configuration.VotingConfigExclusionsHelper;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportClearVotingConfigExclusionsAction
extends TransportClusterManagerNodeAction<ClearVotingConfigExclusionsRequest, ClearVotingConfigExclusionsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClearVotingConfigExclusionsAction.class);

    @Inject
    public TransportClearVotingConfigExclusionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/voting_config/clear_exclusions", transportService, clusterService, threadPool, actionFilters, ClearVotingConfigExclusionsRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected ClearVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new ClearVotingConfigExclusionsResponse(in);
    }

    protected void clusterManagerOperation(final ClearVotingConfigExclusionsRequest request, final ClusterState initialState, final ActionListener<ClearVotingConfigExclusionsResponse> listener) throws Exception {
        final long startTimeMillis = this.threadPool.relativeTimeInMillis();
        Predicate<ClusterState> allExclusionsRemoved = newState -> {
            for (CoordinationMetadata.VotingConfigExclusion tombstone : initialState.getVotingConfigExclusions()) {
                if (!newState.nodes().nodeExists(tombstone.getNodeId())) continue;
                return false;
            }
            return true;
        };
        if (request.getWaitForRemoval() && !allExclusionsRemoved.test(initialState)) {
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, request.getTimeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    TransportClearVotingConfigExclusionsAction.this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, (ActionListener<ClearVotingConfigExclusionsResponse>)listener);
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new SkyliteException("cluster service closed while waiting for removal of nodes " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)new SkyliteTimeoutException("timed out waiting for removal of nodes; if nodes should not be removed, set waitForRemoval to false. " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }
            }, allExclusionsRemoved);
        } else {
            this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
        }
    }

    private void submitClearVotingConfigExclusionsTask(final ClearVotingConfigExclusionsRequest request, final long startTimeMillis, final ActionListener<ClearVotingConfigExclusionsResponse> listener) {
        this.clusterService.submitStateUpdateTask("clear-voting-config-exclusions", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.URGENT){

            public ClusterState execute(ClusterState currentState) {
                return VotingConfigExclusionsHelper.clearExclusionsAndGetState((ClusterState)currentState);
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public TimeValue timeout() {
                return TimeValue.timeValueMillis((long)(request.getTimeout().millis() + startTimeMillis - TransportClearVotingConfigExclusionsAction.this.threadPool.relativeTimeInMillis()));
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new ClearVotingConfigExclusionsResponse());
            }
        });
    }

    protected ClusterBlockException checkBlock(ClearVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClearVotingConfigExclusionsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClearVotingConfigExclusionsAction.class;
        }
    }
}

