/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.hotthreads;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.hotthreads.NodeHotThreads;
import io.skylite.core.action.admin.cluster.node.hotthreads.NodesHotThreadsAction;
import io.skylite.core.action.admin.cluster.node.hotthreads.NodesHotThreadsRequest;
import io.skylite.core.action.admin.cluster.node.hotthreads.NodesHotThreadsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.monitor.jvm.HotThreads;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;

public class TransportNodesHotThreadsAction
extends TransportNodesAction<NodesHotThreadsRequest, NodesHotThreadsResponse, NodeRequest, NodeHotThreads> {
    @Inject
    public TransportNodesHotThreadsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/hot_threads", threadPool, clusterService, transportService, actionFilters, NodesHotThreadsRequest::new, NodeRequest::new, "generic", NodeHotThreads.class);
    }

    @Override
    protected NodesHotThreadsResponse newResponse(NodesHotThreadsRequest request, List<NodeHotThreads> responses, List<FailedNodeException> failures) {
        return new NodesHotThreadsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeRequest newNodeRequest(NodesHotThreadsRequest request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeHotThreads newNodeResponse(StreamInput in) throws IOException {
        return new NodeHotThreads(in);
    }

    @Override
    protected NodeHotThreads nodeOperation(NodeRequest request) {
        HotThreads hotThreads = new HotThreads().busiestThreads(request.request.threads()).type(request.request.type()).interval(request.request.interval()).threadElementsSnapshotCount(request.request.snapshots()).ignoreIdleThreads(request.request.ignoreIdleThreads());
        try {
            return new NodeHotThreads(this.clusterService.localNode(), hotThreads.detect());
        }
        catch (Exception e) {
            throw new SkyliteException("failed to detect hot threads", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        NodesHotThreadsRequest request;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesHotThreadsRequest(in);
        }

        NodeRequest(NodesHotThreadsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return NodesHotThreadsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportNodesHotThreadsAction.class;
        }
    }
}

