/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.info;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.info.NodeInfo;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoAction;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoRequest;
import io.skylite.core.action.admin.cluster.node.info.NodesInfoResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.opensearch.node.NodeService;

public class TransportNodesInfoAction
extends TransportNodesAction<NodesInfoRequest, NodesInfoResponse, NodeInfoRequest, NodeInfo> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesInfoAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesInfoRequest::new, NodeInfoRequest::new, "management", NodeInfo.class);
        this.nodeService = nodeService;
    }

    @Override
    protected NodesInfoResponse newResponse(NodesInfoRequest nodesInfoRequest, List<NodeInfo> responses, List<FailedNodeException> failures) {
        return new NodesInfoResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeInfoRequest newNodeRequest(NodesInfoRequest request) {
        return new NodeInfoRequest(request);
    }

    @Override
    protected NodeInfo newNodeResponse(StreamInput in) throws IOException {
        return new NodeInfo(in);
    }

    @Override
    protected NodeInfo nodeOperation(NodeInfoRequest nodeRequest) {
        NodesInfoRequest request = nodeRequest.request;
        Set metrics = request.requestedMetrics();
        return this.nodeService.info(metrics.contains(NodesInfoRequest.Metric.SETTINGS.metricName()), metrics.contains(NodesInfoRequest.Metric.OS.metricName()), metrics.contains(NodesInfoRequest.Metric.PROCESS.metricName()), metrics.contains(NodesInfoRequest.Metric.JVM.metricName()), metrics.contains(NodesInfoRequest.Metric.THREAD_POOL.metricName()), metrics.contains(NodesInfoRequest.Metric.TRANSPORT.metricName()), metrics.contains(NodesInfoRequest.Metric.HTTP.metricName()), metrics.contains(NodesInfoRequest.Metric.PLUGINS.metricName()), metrics.contains(NodesInfoRequest.Metric.INGEST.metricName()), metrics.contains(NodesInfoRequest.Metric.AGGREGATIONS.metricName()), metrics.contains(NodesInfoRequest.Metric.INDICES.metricName()), metrics.contains(NodesInfoRequest.Metric.SEARCH_PIPELINES.metricName()));
    }

    public static class NodeInfoRequest
    extends TransportRequest {
        NodesInfoRequest request;

        public NodeInfoRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesInfoRequest(in);
        }

        public NodeInfoRequest(NodesInfoRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return NodesInfoAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportNodesInfoAction.class;
        }
    }
}

