/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.stats;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.node.stats.NodeStats;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsAction;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsRequest;
import io.skylite.core.action.admin.cluster.node.stats.NodesStatsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.opensearch.node.NodeService;

public class TransportNodesStatsAction
extends TransportNodesAction<NodesStatsRequest, NodesStatsResponse, NodeStatsRequest, NodeStats> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters) {
        super("cluster:monitor/nodes/stats", threadPool, clusterService, transportService, actionFilters, NodesStatsRequest::new, NodeStatsRequest::new, "management", NodeStats.class);
        this.nodeService = nodeService;
    }

    @Override
    protected NodesStatsResponse newResponse(NodesStatsRequest request, List<NodeStats> responses, List<FailedNodeException> failures) {
        return new NodesStatsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStatsRequest newNodeRequest(NodesStatsRequest request) {
        return new NodeStatsRequest(request);
    }

    @Override
    protected NodeStats newNodeResponse(StreamInput in) throws IOException {
        return new NodeStats(in);
    }

    @Override
    protected NodeStats nodeOperation(NodeStatsRequest nodeStatsRequest) {
        NodesStatsRequest request = nodeStatsRequest.request;
        Set metrics = request.requestedMetrics();
        return this.nodeService.stats(request.indices(), NodesStatsRequest.Metric.OS.containedIn(metrics), NodesStatsRequest.Metric.PROCESS.containedIn(metrics), NodesStatsRequest.Metric.JVM.containedIn(metrics), NodesStatsRequest.Metric.THREAD_POOL.containedIn(metrics), NodesStatsRequest.Metric.FS.containedIn(metrics), NodesStatsRequest.Metric.TRANSPORT.containedIn(metrics), NodesStatsRequest.Metric.HTTP.containedIn(metrics), NodesStatsRequest.Metric.BREAKER.containedIn(metrics), NodesStatsRequest.Metric.SCRIPT.containedIn(metrics), NodesStatsRequest.Metric.DISCOVERY.containedIn(metrics), NodesStatsRequest.Metric.INGEST.containedIn(metrics), NodesStatsRequest.Metric.ADAPTIVE_SELECTION.containedIn(metrics), NodesStatsRequest.Metric.SCRIPT_CACHE.containedIn(metrics), NodesStatsRequest.Metric.INDEXING_PRESSURE.containedIn(metrics), NodesStatsRequest.Metric.SHARD_INDEXING_PRESSURE.containedIn(metrics), NodesStatsRequest.Metric.SEARCH_BACKPRESSURE.containedIn(metrics), NodesStatsRequest.Metric.CLUSTER_MANAGER_THROTTLING.containedIn(metrics), NodesStatsRequest.Metric.WEIGHTED_ROUTING_STATS.containedIn(metrics), NodesStatsRequest.Metric.FILE_CACHE_STATS.containedIn(metrics), NodesStatsRequest.Metric.TASK_CANCELLATION.containedIn(metrics), NodesStatsRequest.Metric.SEARCH_PIPELINE.containedIn(metrics), NodesStatsRequest.Metric.RESOURCE_USAGE_STATS.containedIn(metrics), NodesStatsRequest.Metric.SEGMENT_REPLICATION_BACKPRESSURE.containedIn(metrics), NodesStatsRequest.Metric.REPOSITORIES.containedIn(metrics));
    }

    public static class NodeStatsRequest
    extends TransportRequest {
        NodesStatsRequest request;

        public NodeStatsRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesStatsRequest(in);
        }

        NodeStatsRequest(NodesStatsRequest request) {
            this.request = request;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return NodesStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportNodesStatsAction.class;
        }
    }
}

