/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.node.tasks.cancel;

import io.lucenia.action.support.tasks.TransportTasksAction;
import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.TaskOperationFailure;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksAction;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import io.skylite.core.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskInfo;
import io.skylite.core.transport.TransportService;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    @Inject
    public TransportCancelTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/tasks/cancel", clusterService, transportService, actionFilters, CancelTasksRequest::new, CancelTasksResponse::new, TaskInfo::new, "management");
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processTasks(CancelTasksRequest request, Consumer<CancellableTask> operation) {
        if (request.getTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTaskId().getId());
            if (task != null) {
                if (!request.match((Task)task)) throw new IllegalArgumentException("task [" + String.valueOf(request.getTaskId()) + "] doesn't support this operation");
                operation.accept(task);
                return;
            }
            if (this.taskManager.getTask(request.getTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + String.valueOf(request.getTaskId()) + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] is not found", new Object[]{request.getTaskId()});
        }
        Iterator iterator = this.taskManager.getCancellableTasks().values().iterator();
        while (iterator.hasNext()) {
            CancellableTask task = (CancellableTask)iterator.next();
            if (!request.match((Task)task)) continue;
            operation.accept(task);
        }
    }

    @Override
    protected void taskOperation(CancelTasksRequest request, CancellableTask cancellableTask, ActionListener<TaskInfo> listener) {
        String nodeId = this.clusterService.localNode().getId();
        this.taskManager.cancelTaskAndDescendants(cancellableTask, request.getReason(), request.waitForCompletion(), ActionListenerHelper.map(listener, r -> cancellableTask.taskInfo(nodeId, false)));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return CancelTasksAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportCancelTasksAction.class;
        }
    }
}

