/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.remotestore.stats;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStats;
import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStatsAction;
import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStatsRequest;
import io.skylite.core.action.admin.cluster.remotestore.stats.RemoteStoreStatsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.PlainShardsIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.remote.RemoteSegmentTransferTracker;
import io.skylite.core.index.remote.RemoteStoreStatsTrackerFactory;
import io.skylite.core.index.remote.RemoteTranslogTransferTracker;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportRemoteStoreStatsAction
extends TransportBroadcastByNodeAction<RemoteStoreStatsRequest, RemoteStoreStatsResponse, RemoteStoreStats> {
    private final IndicesService indicesService;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;

    @Inject
    public TransportRemoteStoreStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory) {
        super("cluster:monitor/_remotestore/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, RemoteStoreStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, RemoteStoreStatsRequest request, String[] concreteIndices) {
        ArrayList newShardRoutings = new ArrayList();
        if (request.shards().length > 0) {
            clusterState.routingTable().allShards(concreteIndices).getShardRoutings().forEach(shardRouting -> {
                if (Arrays.asList(request.shards()).contains(Integer.toString(shardRouting.shardId().id()))) {
                    newShardRoutings.add(shardRouting);
                }
            });
        } else {
            newShardRoutings.addAll(clusterState.routingTable().allShards(concreteIndices).getShardRoutings());
        }
        return new PlainShardsIterator(newShardRoutings.stream().filter(shardRouting -> !request.local() || shardRouting.currentNodeId() == null || shardRouting.currentNodeId().equals(clusterState.getNodes().getLocalNodeId())).filter(shardRouting -> Boolean.parseBoolean(clusterState.getMetadata().index(shardRouting.index()).getSettings().get("index.remote_store.enabled"))).collect(Collectors.toList()));
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, RemoteStoreStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, RemoteStoreStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected RemoteStoreStats readShardResult(StreamInput in) throws IOException {
        return new RemoteStoreStats(in);
    }

    @Override
    protected RemoteStoreStatsResponse newResponse(RemoteStoreStatsRequest request, int totalShards, int successfulShards, int failedShards, List<RemoteStoreStats> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new RemoteStoreStatsResponse(responses.toArray(new RemoteStoreStats[0]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected RemoteStoreStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new RemoteStoreStatsRequest(in);
    }

    @Override
    protected RemoteStoreStats shardOperation(RemoteStoreStatsRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        RemoteSegmentTransferTracker remoteSegmentTransferTracker = this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(indexShard.shardId());
        assert (Objects.nonNull(remoteSegmentTransferTracker));
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = this.remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(indexShard.shardId());
        assert (Objects.nonNull(remoteTranslogTransferTracker));
        return new RemoteStoreStats(remoteSegmentTransferTracker.stats(), remoteTranslogTransferTracker.stats(), indexShard.routingEntry());
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return RemoteStoreStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportRemoteStoreStatsAction.class;
        }
    }
}

