/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.repositories.cleanup;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.admin.cluster.repositories.cleanup.CleanupRepositoryAction;
import io.skylite.core.action.admin.cluster.repositories.cleanup.CleanupRepositoryRequest;
import io.skylite.core.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.RepositoryCleanupInProgress;
import io.skylite.core.cluster.SnapshotDeletionsInProgress;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManagerFactory;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryCleanupResult;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.settings.Settings;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public final class TransportCleanupRepositoryAction
extends TransportClusterManagerNodeAction<CleanupRepositoryRequest, CleanupRepositoryResponse> {
    private static final Logger logger = LogManager.getLogger(TransportCleanupRepositoryAction.class);
    private final RepositoriesService repositoriesService;
    private final SnapshotsService snapshotsService;
    private final RemoteStoreLockManagerFactory remoteStoreLockManagerFactory;

    protected String executor() {
        return "same";
    }

    @Inject
    public TransportCleanupRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, SnapshotsService snapshotsService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/_cleanup", transportService, clusterService, threadPool, actionFilters, CleanupRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
        this.snapshotsService = snapshotsService;
        this.remoteStoreLockManagerFactory = new RemoteStoreLockManagerFactory(() -> repositoriesService);
        if (DiscoveryNode.isClusterManagerNode((Settings)clusterService.getSettings())) {
            TransportCleanupRepositoryAction.addClusterStateApplier(clusterService);
        }
    }

    private static void addClusterStateApplier(ClusterService clusterService) {
        clusterService.addStateApplier(event -> {
            if (event.localNodeClusterManager() && !event.previousState().nodes().isLocalNodeElectedClusterManager()) {
                final RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)event.state().custom("repository_cleanup", (ClusterState.Custom)RepositoryCleanupInProgress.EMPTY);
                if (!repositoryCleanupInProgress.hasCleanupInProgress()) {
                    return;
                }
                clusterService.submitStateUpdateTask("clean up repository cleanup task after cluster-manager failover", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                    public ClusterState execute(ClusterState currentState) {
                        return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                    }

                    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                        logger.debug("Removed repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }

                    public void onFailure(String source, Exception e) {
                        logger.warn("Failed to remove repository cleanup task [{}] from cluster state", (Object)repositoryCleanupInProgress);
                    }
                });
            }
        });
    }

    private static ClusterState removeInProgressCleanup(ClusterState currentState) {
        return ((RepositoryCleanupInProgress)currentState.custom("repository_cleanup", (ClusterState.Custom)RepositoryCleanupInProgress.EMPTY)).hasCleanupInProgress() ? ClusterState.builder((ClusterState)currentState).putCustom("repository_cleanup", (ClusterState.Custom)RepositoryCleanupInProgress.EMPTY).build() : currentState;
    }

    protected CleanupRepositoryResponse read(StreamInput in) throws IOException {
        return new CleanupRepositoryResponse(in);
    }

    protected void clusterManagerOperation(CleanupRepositoryRequest request, ClusterState state, ActionListener<CleanupRepositoryResponse> listener) {
        this.cleanupRepo(request.name(), (ActionListener<RepositoryCleanupResult>)ActionListenerHelper.map(listener, CleanupRepositoryResponse::new));
    }

    protected ClusterBlockException checkBlock(CleanupRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private void cleanupRepo(final String repositoryName, ActionListener<RepositoryCleanupResult> listener) {
        Repository repository = this.repositoriesService.repository(repositoryName);
        if (!(repository instanceof BlobStoreRepository)) {
            listener.onFailure((Exception)new IllegalArgumentException("Repository [" + repositoryName + "] does not support repository cleanup"));
            return;
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        StepListener repositoryDataListener = new StepListener();
        repository.getRepositoryData((ActionListener)repositoryDataListener);
        repositoryDataListener.whenComplete(repositoryData -> {
            final long repositoryStateId = repositoryData.getGenId();
            logger.info("Running cleanup operations on repository [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
            this.clusterService.submitStateUpdateTask("cleanup repository [" + repositoryName + "][" + repositoryStateId + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask((ActionListener)listener, blobStoreRepository, (RepositoryData)repositoryData){
                private boolean startedCleanup = false;
                final /* synthetic */ ActionListener val$listener;
                final /* synthetic */ BlobStoreRepository val$blobStoreRepository;
                final /* synthetic */ RepositoryData val$repositoryData;
                {
                    this.val$listener = actionListener;
                    this.val$blobStoreRepository = blobStoreRepository;
                    this.val$repositoryData = repositoryData;
                }

                public ClusterState execute(ClusterState currentState) {
                    RepositoryCleanupInProgress repositoryCleanupInProgress = (RepositoryCleanupInProgress)currentState.custom("repository_cleanup", (ClusterState.Custom)RepositoryCleanupInProgress.EMPTY);
                    if (repositoryCleanupInProgress.hasCleanupInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a repository cleanup is already in-progress in [" + String.valueOf(repositoryCleanupInProgress) + "]");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions", (ClusterState.Custom)SnapshotDeletionsInProgress.EMPTY);
                    if (deletionsInProgress.hasDeletionsInProgress()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently being deleted in [" + String.valueOf(deletionsInProgress) + "]");
                    }
                    SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots", (ClusterState.Custom)SnapshotsInProgress.EMPTY);
                    if (!snapshots.entries().isEmpty()) {
                        throw new IllegalStateException("Cannot cleanup [" + repositoryName + "] - a snapshot is currently running in [" + String.valueOf(snapshots) + "]");
                    }
                    return ClusterState.builder((ClusterState)currentState).putCustom("repository_cleanup", (ClusterState.Custom)new RepositoryCleanupInProgress(Collections.singletonList(RepositoryCleanupInProgress.startedEntry((String)repositoryName, (long)repositoryStateId)))).build();
                }

                public void onFailure(String source, Exception e) {
                    this.after(e, null);
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    this.startedCleanup = true;
                    logger.debug("Initialized repository cleanup in cluster state for [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    TransportCleanupRepositoryAction.this.threadPool.executor("snapshot").execute((Runnable)ActionRunnable.wrap((ActionListener)this.val$listener, l -> this.val$blobStoreRepository.cleanup(repositoryStateId, TransportCleanupRepositoryAction.this.snapshotsService.minCompatibleVersion(newState.nodes().getMinNodeVersion(), this.val$repositoryData, null), TransportCleanupRepositoryAction.this.remoteStoreLockManagerFactory, ActionListenerHelper.wrap(result -> this.after(null, (RepositoryCleanupResult)result), e -> this.after((Exception)e, null)))));
                }

                private void after(final @Nullable Exception failure, final @Nullable RepositoryCleanupResult result) {
                    if (failure == null) {
                        logger.debug("Finished repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId);
                    } else {
                        logger.debug(() -> new ParameterizedMessage("Failed to finish repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                    }
                    assert (failure != null || result != null);
                    if (!this.startedCleanup) {
                        logger.debug("No cleanup task to remove from cluster state because we failed to start one", (Throwable)failure);
                        this.val$listener.onFailure(failure);
                        return;
                    }
                    TransportCleanupRepositoryAction.this.clusterService.submitStateUpdateTask("remove repository cleanup task [" + repositoryName + "][" + repositoryStateId + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) {
                            return TransportCleanupRepositoryAction.removeInProgressCleanup(currentState);
                        }

                        public void onFailure(String source, Exception e) {
                            if (failure != null) {
                                e.addSuppressed(failure);
                            }
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to remove repository cleanup task", (Object)repositoryName), (Throwable)e);
                            val$listener.onFailure(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            if (failure == null) {
                                logger.info("Done with repository cleanup on [{}][{}] with result [{}]", (Object)repositoryName, (Object)repositoryStateId, (Object)result);
                                val$listener.onResponse((Object)result);
                            } else {
                                logger.warn(() -> new ParameterizedMessage("Failed to run repository cleanup operations on [{}][{}]", (Object)repositoryName, (Object)repositoryStateId), (Throwable)failure);
                                val$listener.onFailure(failure);
                            }
                        }
                    });
                }
            });
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return CleanupRepositoryAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportCleanupRepositoryAction.class;
        }
    }
}

