/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.repositories.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesAction;
import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import io.skylite.core.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.RepositoriesMetadata;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class TransportGetRepositoriesAction
extends TransportClusterManagerNodeReadAction<GetRepositoriesRequest, GetRepositoriesResponse> {
    @Inject
    public TransportGetRepositoriesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/get", transportService, clusterService, threadPool, actionFilters, GetRepositoriesRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetRepositoriesResponse read(StreamInput in) throws IOException {
        return new GetRepositoriesResponse(in);
    }

    protected ClusterBlockException checkBlock(GetRepositoriesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(GetRepositoriesRequest request, ClusterState state, ActionListener<GetRepositoriesResponse> listener) {
        Metadata metadata = state.metadata();
        RepositoriesMetadata repositories = (RepositoriesMetadata)metadata.custom("repositories");
        if (request.repositories().length == 0 || request.repositories().length == 1 && "_all".equals(request.repositories()[0])) {
            if (repositories != null) {
                listener.onResponse((Object)new GetRepositoriesResponse(repositories));
            } else {
                listener.onResponse((Object)new GetRepositoriesResponse(new RepositoriesMetadata(Collections.emptyList())));
            }
        } else if (repositories != null) {
            LinkedHashSet<String> repositoriesToGet = new LinkedHashSet<String>();
            for (String repositoryOrPattern : request.repositories()) {
                if (!Regex.isSimpleMatchPattern((String)repositoryOrPattern)) {
                    repositoriesToGet.add(repositoryOrPattern);
                    continue;
                }
                for (RepositoryMetadata repository : repositories.repositories()) {
                    if (!Regex.simpleMatch((String)repositoryOrPattern, (String)repository.name())) continue;
                    repositoriesToGet.add(repository.name());
                }
            }
            ArrayList<RepositoryMetadata> repositoryListBuilder = new ArrayList<RepositoryMetadata>();
            for (String repository : repositoriesToGet) {
                RepositoryMetadata repositoryMetadata = repositories.repository(repository);
                if (repositoryMetadata == null) {
                    listener.onFailure((Exception)new RepositoryMissingException(repository));
                    return;
                }
                repositoryListBuilder.add(repositoryMetadata);
            }
            listener.onResponse((Object)new GetRepositoriesResponse(new RepositoriesMetadata(repositoryListBuilder)));
        } else {
            listener.onFailure((Exception)new RepositoryMissingException(request.repositories()[0]));
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetRepositoriesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetRepositoriesAction.class;
        }
    }
}

