/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.repositories.put;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.repositories.put.PutRepositoryAction;
import io.skylite.core.action.admin.cluster.repositories.put.PutRepositoryRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;

public class TransportPutRepositoryAction
extends TransportClusterManagerNodeAction<PutRepositoryRequest, AcknowledgedResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportPutRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/put", transportService, clusterService, threadPool, actionFilters, PutRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(PutRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(PutRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.registerOrUpdateRepository(request, ActionListenerHelper.delegateFailure(listener, (delegatedListener, response) -> delegatedListener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()))));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PutRepositoryAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportPutRepositoryAction.class;
        }
    }
}

