/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.reroute;

import io.skylite.common.ExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.reroute.ClusterRerouteAction;
import io.skylite.core.action.admin.cluster.reroute.ClusterRerouteRequest;
import io.skylite.core.action.admin.cluster.reroute.ClusterRerouteResponse;
import io.skylite.core.action.admin.indices.shards.IndicesShardStoresRequest;
import io.skylite.core.action.admin.indices.shards.IndicesShardStoresResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.allocation.AllocationCommand;
import io.skylite.core.cluster.routing.allocation.RoutingExplanations;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import org.opensearch.cluster.routing.allocation.command.AllocateStalePrimaryAllocationCommand;

public class TransportClusterRerouteAction
extends TransportClusterManagerNodeAction<ClusterRerouteRequest, ClusterRerouteResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterRerouteAction.class);
    private final AllocationService allocationService;
    private static ClusterManagerTaskThrottler.ThrottlingKey clusterRerouteTaskKey;

    @Inject
    public TransportClusterRerouteAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/reroute", transportService, clusterService, threadPool, actionFilters, ClusterRerouteRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        clusterRerouteTaskKey = clusterService.registerClusterManagerTask("cluster-reroute-api", true);
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(ClusterRerouteRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterRerouteResponse read(StreamInput in) throws IOException {
        return new ClusterRerouteResponse(in);
    }

    protected void clusterManagerOperation(ClusterRerouteRequest request, ClusterState state, ActionListener<ClusterRerouteResponse> listener) {
        HashMap<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations = new HashMap<String, List<AbstractAllocateAllocationCommand>>();
        for (AllocationCommand command : request.getCommands().commands()) {
            if (!(command instanceof AllocateStalePrimaryAllocationCommand)) continue;
            AllocateStalePrimaryAllocationCommand cmd = (AllocateStalePrimaryAllocationCommand)command;
            stalePrimaryAllocations.computeIfAbsent(cmd.index(), k -> new ArrayList()).add(cmd);
        }
        if (stalePrimaryAllocations.isEmpty()) {
            this.submitStateUpdate(request, listener);
        } else {
            this.verifyThenSubmitUpdate(request, listener, stalePrimaryAllocations);
        }
    }

    private void verifyThenSubmitUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener, Map<String, List<AbstractAllocateAllocationCommand>> stalePrimaryAllocations) {
        this.transportService.sendRequest(this.transportService.getLocalNode(), "indices:monitor/shard_stores", (TransportRequest)new IndicesShardStoresRequest().indices(stalePrimaryAllocations.keySet().toArray(Strings.EMPTY_ARRAY)), (TransportResponseHandler)new ActionListenerResponseHandler(ActionListenerHelper.wrap(response -> {
            Map status = response.getStoreStatuses();
            Exception e = null;
            for (Map.Entry entry : stalePrimaryAllocations.entrySet()) {
                String index = (String)entry.getKey();
                Map indexStatus = (Map)status.get(index);
                if (indexStatus == null) continue;
                for (AbstractAllocateAllocationCommand command : (List)entry.getValue()) {
                    List shardStatus = (List)indexStatus.get(command.shardId());
                    if (shardStatus == null || shardStatus.isEmpty()) {
                        e = (Exception)ExceptionsHelper.useOrSuppress(e, (Throwable)new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on any node"));
                        continue;
                    }
                    if (!shardStatus.stream().noneMatch(storeStatus -> {
                        DiscoveryNode node = storeStatus.getNode();
                        String nodeInCommand = command.node();
                        return nodeInCommand.equals(node.getName()) || nodeInCommand.equals(node.getId());
                    })) continue;
                    e = (Exception)ExceptionsHelper.useOrSuppress((Throwable)e, (Throwable)new IllegalArgumentException("No data for shard [" + command.shardId() + "] of index [" + index + "] found on node [" + command.node() + "]"));
                }
            }
            if (e == null) {
                this.submitStateUpdate(request, listener);
            } else {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)), IndicesShardStoresResponse::new));
    }

    private void submitStateUpdate(ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
        this.clusterService.submitStateUpdateTask("cluster_reroute (api)", (ClusterStateTaskConfig)new ClusterRerouteResponseAckedClusterStateUpdateTask(logger, this.allocationService, request, (ActionListener<ClusterRerouteResponse>)ActionListenerHelper.map(listener, response -> {
            if (!request.dryRun()) {
                response.getExplanations().getYesDecisionMessages().forEach(arg_0 -> ((Logger)logger).info(arg_0));
            }
            return response;
        })));
    }

    static class ClusterRerouteResponseAckedClusterStateUpdateTask
    extends AckedClusterStateUpdateTask<ClusterRerouteResponse> {
        private final ClusterRerouteRequest request;
        private final ActionListener<ClusterRerouteResponse> listener;
        private final Logger logger;
        private final AllocationService allocationService;
        private volatile ClusterState clusterStateToSend;
        private volatile RoutingExplanations explanations;

        ClusterRerouteResponseAckedClusterStateUpdateTask(Logger logger, AllocationService allocationService, ClusterRerouteRequest request, ActionListener<ClusterRerouteResponse> listener) {
            super(Priority.IMMEDIATE, (AckedRequest)request, listener);
            this.request = request;
            this.listener = listener;
            this.logger = logger;
            this.allocationService = allocationService;
        }

        public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
            return clusterRerouteTaskKey;
        }

        protected ClusterRerouteResponse newResponse(boolean acknowledged) {
            return new ClusterRerouteResponse(acknowledged, this.clusterStateToSend, this.explanations);
        }

        public void onAckTimeout() {
            this.listener.onResponse((Object)new ClusterRerouteResponse(false, this.clusterStateToSend, new RoutingExplanations()));
        }

        public void onFailure(String source, Exception e) {
            this.logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
            super.onFailure(source, e);
        }

        public ClusterState execute(ClusterState currentState) {
            AllocationService.CommandsResult commandsResult = this.allocationService.reroute(currentState, this.request.getCommands(), this.request.explain(), this.request.isRetryFailed());
            this.clusterStateToSend = commandsResult.getClusterState();
            this.explanations = commandsResult.explanations();
            if (this.request.dryRun()) {
                return currentState;
            }
            return commandsResult.getClusterState();
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterRerouteAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterRerouteAction.class;
        }
    }
}

