/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.settings;

import io.lucenia.action.admin.cluster.settings.SettingsUpdater;
import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.settings.ClusterUpdateSettingsAction;
import io.skylite.core.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import io.skylite.core.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.AckedRequest;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.AckedClusterStateUpdateTask;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.common.Priority;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.remote.RemoteMigrationIndexMetadataUpdater;
import io.skylite.core.node.RemoteStoreNodeService;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsException;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.routing.allocation.AllocationService;

public class TransportClusterUpdateSettingsAction
extends TransportClusterManagerNodeAction<ClusterUpdateSettingsRequest, ClusterUpdateSettingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClusterUpdateSettingsAction.class);
    private final AllocationService allocationService;
    private final ClusterSettings clusterSettings;
    private final ClusterManagerTaskThrottler.ThrottlingKey clusterUpdateSettingTaskKey;

    @Inject
    public TransportClusterUpdateSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, AllocationService allocationService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterSettings clusterSettings) {
        super("cluster:admin/settings/update", false, transportService, clusterService, threadPool, actionFilters, ClusterUpdateSettingsRequest::new, indexNameExpressionResolver);
        this.allocationService = allocationService;
        this.clusterSettings = clusterSettings;
        this.clusterUpdateSettingTaskKey = clusterService.registerClusterManagerTask("cluster-update-settings", true);
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(ClusterUpdateSettingsRequest request, ClusterState state) {
        if (request.transientSettings().size() + request.persistentSettings().size() == 1 && (Metadata.SETTING_READ_ONLY_SETTING.exists(request.persistentSettings()) || Metadata.SETTING_READ_ONLY_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.transientSettings()) || Metadata.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.exists(request.persistentSettings()))) {
            return null;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected ClusterUpdateSettingsResponse read(StreamInput in) throws IOException {
        return new ClusterUpdateSettingsResponse(in);
    }

    protected void clusterManagerOperation(final ClusterUpdateSettingsRequest request, ClusterState state, final ActionListener<ClusterUpdateSettingsResponse> listener) {
        final SettingsUpdater updater = new SettingsUpdater(this.clusterSettings);
        this.clusterService.submitStateUpdateTask("cluster_update_settings", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.IMMEDIATE, (AckedRequest)request, listener){
            private volatile boolean changed;
            {
                super(priority, request2, listener2);
                this.changed = false;
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return TransportClusterUpdateSettingsAction.this.clusterUpdateSettingTaskKey;
            }

            protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                return new ClusterUpdateSettingsResponse(acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
            }

            public void onAllNodesAcked(@Nullable Exception e) {
                if (this.changed) {
                    this.reroute(true);
                } else {
                    super.onAllNodesAcked(e);
                }
            }

            public void onAckTimeout() {
                if (this.changed) {
                    this.reroute(false);
                } else {
                    super.onAckTimeout();
                }
            }

            private void reroute(final boolean updateSettingsAcked) {
                if (!TransportClusterUpdateSettingsAction.this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
                    logger.debug("Skipping reroute after cluster update settings, because node is no longer cluster-manager");
                    listener.onResponse((Object)new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    return;
                }
                TransportClusterUpdateSettingsAction.this.clusterService.submitStateUpdateTask("reroute_after_cluster_update_settings", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<ClusterUpdateSettingsResponse>(Priority.URGENT, (AckedRequest)request, listener){

                    public boolean mustAck(DiscoveryNode discoveryNode) {
                        return updateSettingsAcked;
                    }

                    protected ClusterUpdateSettingsResponse newResponse(boolean acknowledged) {
                        return new ClusterUpdateSettingsResponse(updateSettingsAcked && acknowledged, updater.getTransientUpdates(), updater.getPersistentUpdate());
                    }

                    public void onNoLongerClusterManager(String source) {
                        logger.debug("failed to preform reroute after cluster settings were updated - current node is no longer a cluster-manager");
                        listener.onResponse((Object)new ClusterUpdateSettingsResponse(updateSettingsAcked, updater.getTransientUpdates(), updater.getPersistentUpdate()));
                    }

                    public void onFailure(String source, Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                        listener.onFailure((Exception)new SkyliteException("reroute after update settings failed", (Throwable)e, new Object[0]));
                    }

                    public ClusterState execute(ClusterState currentState) {
                        return TransportClusterUpdateSettingsAction.this.allocationService.reroute(currentState, "reroute after cluster update settings");
                    }
                });
            }

            public void onFailure(String source, Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to perform [{}]", (Object)source), (Throwable)e);
                super.onFailure(source, e);
            }

            public ClusterState execute(ClusterState currentState) {
                ClusterState clusterState = updater.updateSettings(currentState, TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.transientSettings()), TransportClusterUpdateSettingsAction.this.clusterSettings.upgradeSettings(request.persistentSettings()), logger);
                this.changed = clusterState != currentState;
                return clusterState;
            }
        });
    }

    public void validateCompatibilityModeSettingRequest(ClusterUpdateSettingsRequest request, ClusterState clusterState) {
        Settings settings = Settings.builder().put(request.persistentSettings()).put(request.transientSettings()).build();
        if (RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.exists(settings)) {
            String value = settings.get(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.getKey()).toLowerCase(Locale.ROOT);
            this.validateAllNodesOfSameVersion(clusterState.nodes());
            if (value.equals(RemoteStoreNodeService.CompatibilityMode.STRICT.mode)) {
                this.validateAllNodesOfSameType(clusterState.nodes());
                this.validateIndexSettings(clusterState);
            }
        }
    }

    private void validateAllNodesOfSameVersion(DiscoveryNodes discoveryNodes) {
        if (!discoveryNodes.getMaxNodeVersion().equals((Object)discoveryNodes.getMinNodeVersion())) {
            throw new SettingsException("can not change the compatibility mode when all the nodes in cluster are not of the same version");
        }
    }

    private void validateAllNodesOfSameType(DiscoveryNodes discoveryNodes) {
        Set nodeTypes = discoveryNodes.getNodes().values().stream().map(DiscoveryNode::isRemoteStoreNode).collect(Collectors.toSet());
        if (nodeTypes.size() != 1) {
            throw new SettingsException("can not switch to STRICT compatibility mode when the cluster contains both remote and non-remote nodes");
        }
    }

    private void validateIndexSettings(ClusterState clusterState) {
        Collection allIndicesMetadata = clusterState.metadata().indices().values();
        if (!allIndicesMetadata.isEmpty() && allIndicesMetadata.stream().anyMatch(indexMetadata -> !RemoteMigrationIndexMetadataUpdater.indexHasAllRemoteStoreRelatedMetadata((IndexMetadata)indexMetadata))) {
            throw new SettingsException("can not switch to STRICT compatibility mode since all indices in the cluster does not have remote store based index settings");
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterUpdateSettingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterUpdateSettingsAction.class;
        }
    }
}

