/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.shards;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.cluster.shards.ClusterSearchShardsAction;
import io.skylite.core.action.admin.cluster.shards.ClusterSearchShardsGroup;
import io.skylite.core.action.admin.cluster.shards.ClusterSearchShardsRequest;
import io.skylite.core.action.admin.cluster.shards.ClusterSearchShardsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opensearch.indices.IndicesService;

public class TransportClusterSearchShardsAction
extends TransportClusterManagerNodeReadAction<ClusterSearchShardsRequest, ClusterSearchShardsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportClusterSearchShardsAction(TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/shards/search_shards", transportService, clusterService, threadPool, actionFilters, ClusterSearchShardsRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(ClusterSearchShardsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected ClusterSearchShardsResponse read(StreamInput in) throws IOException {
        return new ClusterSearchShardsResponse(in);
    }

    protected void clusterManagerOperation(ClusterSearchShardsRequest request, ClusterState state, ActionListener<ClusterSearchShardsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
        Map routingMap = this.indexNameExpressionResolver.resolveSearchRouting(state, request.routing(), request.indices());
        HashMap<String, AliasFilter> indicesAndFilters = new HashMap<String, AliasFilter>();
        Set indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(clusterState, request.indices());
        for (String index : concreteIndices) {
            AliasFilter aliasFilter = this.indicesService.buildAliasFilter(clusterState, index, indicesAndAliases);
            String[] aliases = this.indexNameExpressionResolver.indexAliases(clusterState, index, aliasMetadata -> true, true, indicesAndAliases);
            indicesAndFilters.put(index, new AliasFilter(aliasFilter.getQueryBuilder(), aliases));
        }
        HashSet<String> nodeIds = new HashSet<String>();
        GroupShardsIterator groupShardsIterator = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, routingMap, request.preference());
        ClusterSearchShardsGroup[] groupResponses = new ClusterSearchShardsGroup[groupShardsIterator.size()];
        int currentGroup = 0;
        for (ShardIterator shardIt : groupShardsIterator) {
            ShardRouting shard;
            ShardId shardId = shardIt.shardId();
            ShardRouting[] shardRoutings = new ShardRouting[shardIt.size()];
            int currentShard = 0;
            shardIt.reset();
            while ((shard = shardIt.nextOrNull()) != null) {
                shardRoutings[currentShard++] = shard;
                nodeIds.add(shard.currentNodeId());
            }
            groupResponses[currentGroup++] = new ClusterSearchShardsGroup(shardId, shardRoutings);
        }
        DiscoveryNode[] nodes = new DiscoveryNode[nodeIds.size()];
        int currentNode = 0;
        for (String nodeId : nodeIds) {
            nodes[currentNode++] = clusterState.getNodes().get(nodeId);
        }
        listener.onResponse((Object)new ClusterSearchShardsResponse(groupResponses, nodes, indicesAndFilters));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterSearchShardsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportClusterSearchShardsAction.class;
        }
    }
}

