/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.shards.routing.weighted.put;

import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.put.ClusterAddWeightedRoutingAction;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingRequest;
import io.skylite.core.action.admin.cluster.shards.routing.weighted.put.ClusterPutWeightedRoutingResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.cluster.routing.WeightedRoutingService;

public class TransportAddWeightedRoutingAction
extends TransportClusterManagerNodeAction<ClusterPutWeightedRoutingRequest, ClusterPutWeightedRoutingResponse> {
    private final WeightedRoutingService weightedRoutingService;

    @Inject
    public TransportAddWeightedRoutingAction(TransportService transportService, ClusterService clusterService, WeightedRoutingService weightedRoutingService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/routing/awareness/weights/put", transportService, clusterService, threadPool, actionFilters, ClusterPutWeightedRoutingRequest::new, indexNameExpressionResolver);
        this.weightedRoutingService = weightedRoutingService;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterPutWeightedRoutingResponse read(StreamInput in) throws IOException {
        return new ClusterPutWeightedRoutingResponse(in);
    }

    protected void clusterManagerOperation(ClusterPutWeightedRoutingRequest request, ClusterState state, ActionListener<ClusterPutWeightedRoutingResponse> listener) throws Exception {
        try {
            this.weightedRoutingService.verifyAwarenessAttribute(request.getWeightedRouting().attributeName());
        }
        catch (ActionRequestValidationException ex) {
            listener.onFailure((Exception)((Object)ex));
            return;
        }
        this.weightedRoutingService.registerWeightedRoutingMetadata(request, (ActionListener<ClusterStateUpdateResponse>)ActionListenerHelper.delegateFailure(listener, (delegatedListener, response) -> delegatedListener.onResponse((Object)new ClusterPutWeightedRoutingResponse(response.isAcknowledged()))));
    }

    protected ClusterBlockException checkBlock(ClusterPutWeightedRoutingRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ClusterAddWeightedRoutingAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAddWeightedRoutingAction.class;
        }
    }
}

