/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.snapshots.get;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.StepListener;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsAction;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.SnapshotsInProgress;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.repositories.IndexId;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryData;
import io.skylite.core.snapshots.SnapshotException;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotMissingException;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.CollectionUtil;

public class TransportGetSnapshotsAction
extends TransportClusterManagerNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetSnapshotsAction.class);
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportGetSnapshotsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, GetSnapshotsRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
    }

    protected String executor() {
        return "generic";
    }

    protected GetSnapshotsResponse read(StreamInput in) throws IOException {
        return new GetSnapshotsResponse(in);
    }

    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        try {
            String repository = request.repository();
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom("snapshots");
            HashMap<String, SnapshotId> allSnapshotIds = new HashMap<String, SnapshotId>();
            ArrayList<SnapshotInfo> currentSnapshots = new ArrayList<SnapshotInfo>();
            for (SnapshotInfo snapshotInfo : TransportGetSnapshotsAction.sortedCurrentSnapshots(snapshotsInProgress, repository)) {
                SnapshotId snapshotId = snapshotInfo.snapshotId();
                allSnapshotIds.put(snapshotId.getName(), snapshotId);
                currentSnapshots.add(snapshotInfo);
            }
            StepListener repositoryDataListener = new StepListener();
            if (!this.isCurrentSnapshotsOnly(request.snapshots())) {
                this.repositoriesService.getRepositoryData(repository, (ActionListener)repositoryDataListener);
            } else {
                repositoryDataListener.onResponse(null);
            }
            repositoryDataListener.whenComplete(repositoryData -> {
                List<Object> snapshotInfos;
                if (repositoryData != null) {
                    for (String[] snapshotId : repositoryData.getSnapshotIds()) {
                        allSnapshotIds.put(snapshotId.getName(), (SnapshotId)snapshotId);
                    }
                }
                HashSet<SnapshotId> toResolve = new HashSet<SnapshotId>();
                if (this.isAllSnapshots(request.snapshots())) {
                    toResolve.addAll(allSnapshotIds.values());
                } else {
                    for (String snapshotOrPattern : request.snapshots()) {
                        if ("_current".equalsIgnoreCase(snapshotOrPattern)) {
                            toResolve.addAll(currentSnapshots.stream().map(SnapshotInfo::snapshotId).collect(Collectors.toList()));
                            continue;
                        }
                        if (!Regex.isSimpleMatchPattern((String)snapshotOrPattern)) {
                            if (allSnapshotIds.containsKey(snapshotOrPattern)) {
                                toResolve.add((SnapshotId)allSnapshotIds.get(snapshotOrPattern));
                                continue;
                            }
                            if (request.ignoreUnavailable()) continue;
                            throw new SnapshotMissingException(repository, snapshotOrPattern);
                        }
                        for (Map.Entry entry : allSnapshotIds.entrySet()) {
                            if (!Regex.simpleMatch((String)snapshotOrPattern, (String)((String)entry.getKey()))) continue;
                            toResolve.add((SnapshotId)entry.getValue());
                        }
                    }
                    if (toResolve.isEmpty() && !request.ignoreUnavailable() && !this.isCurrentSnapshotsOnly(request.snapshots())) {
                        throw new SnapshotMissingException(repository, request.snapshots()[0]);
                    }
                }
                if (request.verbose()) {
                    snapshotInfos = this.snapshots(snapshotsInProgress, repository, new ArrayList<SnapshotId>(toResolve), request.ignoreUnavailable());
                } else if (repositoryData != null) {
                    snapshotInfos = this.buildSimpleSnapshotInfos((Set<SnapshotId>)toResolve, (RepositoryData)repositoryData, (List<SnapshotInfo>)currentSnapshots);
                } else {
                    snapshotInfos = currentSnapshots.stream().map(SnapshotInfo::basic).collect(Collectors.toList());
                    CollectionUtil.timSort(snapshotInfos);
                }
                listener.onResponse((Object)new GetSnapshotsResponse(snapshotInfos));
            }, arg_0 -> listener.onFailure(arg_0));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static List<SnapshotInfo> sortedCurrentSnapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repositoryName) {
        ArrayList<SnapshotInfo> snapshotList = new ArrayList<SnapshotInfo>();
        List entries = SnapshotsService.currentSnapshots((SnapshotsInProgress)snapshotsInProgress, (String)repositoryName, Collections.emptyList());
        for (SnapshotsInProgress.Entry entry : entries) {
            snapshotList.add(new SnapshotInfo(entry));
        }
        CollectionUtil.timSort(snapshotList);
        return Collections.unmodifiableList(snapshotList);
    }

    private List<SnapshotInfo> snapshots(@Nullable SnapshotsInProgress snapshotsInProgress, String repositoryName, List<SnapshotId> snapshotIds, boolean ignoreUnavailable) {
        HashSet<SnapshotInfo> snapshotSet = new HashSet<SnapshotInfo>();
        HashSet<SnapshotId> snapshotIdsToIterate = new HashSet<SnapshotId>(snapshotIds);
        List entries = SnapshotsService.currentSnapshots((SnapshotsInProgress)snapshotsInProgress, (String)repositoryName, snapshotIdsToIterate.stream().map(SnapshotId::getName).collect(Collectors.toList()));
        for (Object entry : entries) {
            if (!snapshotIdsToIterate.remove(entry.snapshot().getSnapshotId())) continue;
            snapshotSet.add(new SnapshotInfo((SnapshotsInProgress.Entry)entry));
        }
        Repository repository = this.repositoriesService.repository(repositoryName);
        for (SnapshotId snapshotId : snapshotIdsToIterate) {
            try {
                snapshotSet.add(repository.getSnapshotInfo(snapshotId));
            }
            catch (Exception ex) {
                if (ignoreUnavailable) {
                    logger.warn(() -> new ParameterizedMessage("failed to get snapshot [{}]", (Object)snapshotId), (Throwable)ex);
                    continue;
                }
                if (ex instanceof SnapshotException) {
                    throw ex;
                }
                throw new SnapshotException(repositoryName, snapshotId, "Snapshot could not be read", (Throwable)ex);
            }
        }
        ArrayList snapshotList = new ArrayList(snapshotSet);
        CollectionUtil.timSort(snapshotList);
        return Collections.unmodifiableList(snapshotList);
    }

    private boolean isAllSnapshots(String[] snapshots) {
        return snapshots.length == 0 || snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0]);
    }

    private boolean isCurrentSnapshotsOnly(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }

    private List<SnapshotInfo> buildSimpleSnapshotInfos(Set<SnapshotId> toResolve, RepositoryData repositoryData, List<SnapshotInfo> currentSnapshots) {
        ArrayList<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : currentSnapshots) {
            if (!toResolve.remove(snapshotInfo.snapshotId())) continue;
            snapshotInfos.add(snapshotInfo.basic());
        }
        HashMap snapshotsToIndices = new HashMap();
        for (IndexId indexId : repositoryData.getIndices().values()) {
            for (SnapshotId snapshotId : repositoryData.getSnapshots(indexId)) {
                if (!toResolve.contains(snapshotId)) continue;
                snapshotsToIndices.computeIfAbsent(snapshotId, k -> new ArrayList()).add(indexId.getName());
            }
        }
        for (SnapshotId snapshotId : toResolve) {
            List indices = snapshotsToIndices.getOrDefault(snapshotId, Collections.emptyList());
            CollectionUtil.timSort(indices);
            snapshotInfos.add(new SnapshotInfo(snapshotId, indices, Collections.emptyList(), repositoryData.getSnapshotState(snapshotId)));
        }
        CollectionUtil.timSort(snapshotInfos);
        return Collections.unmodifiableList(snapshotInfos);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetSnapshotsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetSnapshotsAction.class;
        }
    }
}

