/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.cluster.snapshots.restore;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import io.skylite.core.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.snapshots.RestoreCompletionResponse;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.snapshots.RestoreService;

public class TransportRestoreSnapshotAction
extends TransportClusterManagerNodeAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/restore", transportService, clusterService, threadPool, actionFilters, RestoreSnapshotRequest::new, indexNameExpressionResolver);
        this.restoreService = restoreService;
    }

    protected String executor() {
        return "generic";
    }

    protected RestoreSnapshotResponse read(StreamInput in) throws IOException {
        return new RestoreSnapshotResponse(in);
    }

    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    protected void clusterManagerOperation(RestoreSnapshotRequest request, ClusterState state, ActionListener<RestoreSnapshotResponse> listener) {
        this.restoreService.restoreSnapshot(request, (ActionListener<RestoreCompletionResponse>)ActionListenerHelper.delegateFailure(listener, (delegatedListener, restoreCompletionResponse) -> {
            if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                RestoreClusterStateListener.createAndRegisterListener((ClusterService)this.clusterService, (RestoreCompletionResponse)restoreCompletionResponse, (ActionListener)delegatedListener, RestoreSnapshotResponse::new);
            } else {
                delegatedListener.onResponse((Object)new RestoreSnapshotResponse(restoreCompletionResponse.getRestoreInfo()));
            }
        }));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return RestoreSnapshotAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportRestoreSnapshotAction.class;
        }
    }
}

