/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.alias;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.AliasesRequest;
import io.skylite.core.action.RequestValidators;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesAction;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.alias.IndicesAliasesRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.AliasAction;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataIndexAliasesService;
import org.opensearch.rest.action.admin.indices.AliasesNotFoundException;

public class TransportIndicesAliasesAction
extends TransportClusterManagerNodeAction<IndicesAliasesRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportIndicesAliasesAction.class);
    private final MetadataIndexAliasesService indexAliasesService;
    private final RequestValidators<IndicesAliasesRequest> requestValidators;

    @Inject
    public TransportIndicesAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexAliasesService indexAliasesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<IndicesAliasesRequest> requestValidators) {
        super("indices:admin/aliases", transportService, clusterService, threadPool, actionFilters, IndicesAliasesRequest::new, indexNameExpressionResolver);
        this.indexAliasesService = indexAliasesService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet indices = new HashSet();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            Collections.addAll(indices, aliasAction.indices());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices.toArray(new String[0]));
    }

    protected void clusterManagerOperation(IndicesAliasesRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        List actions = request.aliasActions();
        ArrayList<Object> finalActions = new ArrayList<Object>();
        HashSet aliases = new HashSet();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), false, action.indices())) {
                IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(concreteIndex.getName());
                assert (indexAbstraction != null) : "invalid cluster metadata. index [" + concreteIndex.getName() + "] was not found";
                if (indexAbstraction.getParentDataStream() == null) continue;
                throw new IllegalArgumentException("The provided expressions [" + String.join((CharSequence)",", action.indices()) + "] match a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support aliases.");
            }
            Optional maybeException = this.requestValidators.validateRequest((ActionRequest)request, state, concreteIndices);
            if (maybeException.isPresent()) {
                listener.onFailure((Exception)maybeException.get());
                return;
            }
            Collections.addAll(aliases, action.getOriginalAliases());
            block7: for (Index index : concreteIndices) {
                switch (action.actionType()) {
                    case ADD: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Add(index.getName(), alias, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex(), action.isHidden()));
                        }
                        continue block7;
                    }
                    case REMOVE: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metadata(), index.getName())) {
                            finalActions.add(new AliasAction.Remove(index.getName(), alias, action.mustExist()));
                        }
                        continue block7;
                    }
                    case REMOVE_INDEX: {
                        finalActions.add(new AliasAction.RemoveIndex(index.getName()));
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + String.valueOf(action.actionType()) + "]");
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            throw new AliasesNotFoundException(aliases.toArray(new String[0]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList(finalActions)).ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout());
        this.indexAliasesService.indicesAliases(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug("failed to perform aliases", (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private static String[] concreteAliases(IndicesAliasesRequest.AliasActions action, Metadata metadata, String concreteIndex) {
        if (action.expandAliasesWildcards()) {
            String[] indexAsArray = new String[]{concreteIndex};
            Map aliasMetadata = metadata.findAliases((AliasesRequest)action, indexAsArray);
            ArrayList<String> finalAliases = new ArrayList<String>();
            for (List curAliases : aliasMetadata.values()) {
                for (AliasMetadata aliasMeta : curAliases) {
                    finalAliases.add(aliasMeta.alias());
                }
            }
            return finalAliases.toArray(new String[0]);
        }
        return action.aliases();
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return IndicesAliasesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportIndicesAliasesAction.class;
        }
    }
}

