/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.alias.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.AliasesRequest;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.alias.get.GetAliasesAction;
import io.skylite.core.action.admin.indices.alias.get.GetAliasesRequest;
import io.skylite.core.action.admin.indices.alias.get.GetAliasesResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TransportGetAliasesAction
extends TransportClusterManagerNodeReadAction<GetAliasesRequest, GetAliasesResponse> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportGetAliasesAction.class);
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/aliases/get", transportService, clusterService, threadPool, actionFilters, GetAliasesRequest::new, indexNameExpressionResolver);
        this.systemIndices = systemIndices;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(GetAliasesRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, (IndicesRequest)request));
    }

    protected GetAliasesResponse read(StreamInput in) throws IOException {
        return new GetAliasesResponse(in);
    }

    protected void clusterManagerOperation(GetAliasesRequest request, ClusterState state, ActionListener<GetAliasesResponse> listener) {
        String[] concreteIndices;
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().newStoredContext(false);){
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        }
        boolean systemIndexAccessAllowed = this.indexNameExpressionResolver.isSystemIndexAccessAllowed();
        Map aliases = state.metadata().findAliases((AliasesRequest)request, concreteIndices);
        listener.onResponse((Object)new GetAliasesResponse(TransportGetAliasesAction.postProcess(request, concreteIndices, aliases, state, systemIndexAccessAllowed, this.systemIndices)));
    }

    static Map<String, List<AliasMetadata>> postProcess(GetAliasesRequest request, String[] concreteIndices, Map<String, List<AliasMetadata>> aliases, ClusterState state, boolean systemIndexAccessAllowed, SystemIndices systemIndices) {
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        HashMap<String, List<AliasMetadata>> mapBuilder = new HashMap<String, List<AliasMetadata>>(aliases);
        for (String index : concreteIndices) {
            if (aliases.get(index) != null || !noAliasesSpecified) continue;
            List previous = mapBuilder.put(index, Collections.emptyList());
            assert (previous == null);
        }
        Map<String, List<AliasMetadata>> finalResponse = Collections.unmodifiableMap(mapBuilder);
        if (!systemIndexAccessAllowed) {
            TransportGetAliasesAction.checkSystemIndexAccess(request, systemIndices, state, finalResponse);
        }
        return finalResponse;
    }

    private static void checkSystemIndexAccess(GetAliasesRequest request, SystemIndices systemIndices, ClusterState state, Map<String, List<AliasMetadata>> aliasesMap) {
        HashSet<String> systemIndicesNames = new HashSet<String>();
        for (String indexName : aliasesMap.keySet()) {
            IndexMetadata index = state.metadata().index(indexName);
            if (index == null || !index.isSystem()) continue;
            systemIndicesNames.add(indexName);
        }
        if (!systemIndicesNames.isEmpty()) {
            systemIndicesNames.forEach(systemIndexName -> deprecationLogger.deprecate("open_system_index_access_" + systemIndexName, "this request accesses system indices: [{}], but in a future major version, direct access to system indices will be prevented by default", new Object[]{systemIndexName}));
        } else {
            TransportGetAliasesAction.checkSystemAliasAccess(request, systemIndices);
        }
    }

    private static void checkSystemAliasAccess(GetAliasesRequest request, SystemIndices systemIndices) {
        List systemAliases = Arrays.stream(request.aliases()).filter(alias -> systemIndices.isSystemIndex(alias)).collect(Collectors.toList());
        if (!systemAliases.isEmpty()) {
            deprecationLogger.deprecate("open_system_alias_access", "this request accesses aliases with names reserved for system indices: {}, but in a future major version, directaccess to system indices and their aliases will not be allowed", new Object[]{systemAliases});
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetAliasesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetAliasesAction.class;
        }
    }
}

