/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.create;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.alias.Alias;
import io.skylite.core.action.admin.indices.create.CreateIndexAction;
import io.skylite.core.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.CreateIndexClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.indices.SystemIndexDescriptor;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;

public class TransportCreateIndexAction
extends TransportClusterManagerNodeAction<CreateIndexRequest, CreateIndexResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportCreateIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/create", transportService, clusterService, threadPool, actionFilters, CreateIndexRequest::new, indexNameExpressionResolver);
        this.createIndexService = createIndexService;
        this.systemIndices = systemIndices;
    }

    protected String executor() {
        return "same";
    }

    protected CreateIndexResponse read(StreamInput in) throws IOException {
        return new CreateIndexResponse(in);
    }

    protected ClusterBlockException checkBlock(CreateIndexRequest request, ClusterState state) {
        ClusterBlockException clusterBlockException = state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.index());
        if (clusterBlockException == null) {
            return state.blocks().createIndexBlockedException(ClusterBlockLevel.CREATE_INDEX);
        }
        return clusterBlockException;
    }

    protected void clusterManagerOperation(CreateIndexRequest request, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        String indexName;
        SystemIndexDescriptor descriptor;
        String cause = request.cause();
        if (cause.isEmpty()) {
            cause = "api";
        }
        CreateIndexClusterStateUpdateRequest updateRequest = (descriptor = this.systemIndices.findMatchingDescriptor(indexName = this.indexNameExpressionResolver.resolveDateMathExpression(request.index()))) != null && descriptor.isAutomaticallyManaged() ? this.buildSystemIndexUpdateRequest(request, cause, descriptor) : this.buildUpdateRequest(request, cause, indexName);
        this.createIndexService.createIndex(updateRequest, (ActionListener<CreateIndexClusterStateUpdateResponse>)ActionListenerHelper.map(listener, response -> new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), indexName)));
    }

    private CreateIndexClusterStateUpdateRequest buildUpdateRequest(CreateIndexRequest request, String cause, String indexName) {
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)new CreateIndexClusterStateUpdateRequest(cause, indexName, request.index()).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).settings(request.settings()).mappings(request.mappings()).aliases(request.aliases()).waitForActiveShards(request.waitForActiveShards());
    }

    private CreateIndexClusterStateUpdateRequest buildSystemIndexUpdateRequest(CreateIndexRequest request, String cause, SystemIndexDescriptor descriptor) {
        Settings settings = Objects.requireNonNullElse(descriptor.getSettings(), Settings.EMPTY);
        Set<Object> aliases = descriptor.getAliasName() == null ? Set.of() : Set.of(new Alias(descriptor.getAliasName()));
        CreateIndexClusterStateUpdateRequest updateRequest = new CreateIndexClusterStateUpdateRequest(cause, descriptor.getPrimaryIndex(), request.index());
        return ((CreateIndexClusterStateUpdateRequest)((CreateIndexClusterStateUpdateRequest)updateRequest.ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).aliases(aliases).waitForActiveShards(ActiveShardCount.ALL).mappings(descriptor.getMappings()).settings(settings);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return CreateIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportCreateIndexAction.class;
        }
    }
}

