/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.dangling.import_index;

import io.skylite.SkyliteException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexAction;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import io.skylite.core.action.admin.indices.dangling.find.FindDanglingIndexResponse;
import io.skylite.core.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import io.skylite.core.action.admin.indices.dangling.import_index.ImportDanglingIndexAction;
import io.skylite.core.action.admin.indices.dangling.import_index.ImportDanglingIndexRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.gateway.LocalAllocateDangledIndices;

public class TransportImportDanglingIndexAction
extends HandledTransportAction<ImportDanglingIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportImportDanglingIndexAction.class);
    private final LocalAllocateDangledIndices danglingIndexAllocator;
    private final NodeClient nodeClient;

    @Inject
    public TransportImportDanglingIndexAction(ActionFilters actionFilters, TransportService transportService, LocalAllocateDangledIndices danglingIndexAllocator, NodeClient nodeClient) {
        super("cluster:admin/indices/dangling/import", transportService, actionFilters, ImportDanglingIndexRequest::new);
        this.danglingIndexAllocator = danglingIndexAllocator;
        this.nodeClient = nodeClient;
    }

    protected void doExecute(Task task, final ImportDanglingIndexRequest importRequest, final ActionListener<AcknowledgedResponse> importListener) {
        this.findDanglingIndex(importRequest, new ActionListener<IndexMetadata>(){

            public void onResponse(IndexMetadata indexMetaDataToImport) {
                if (!importRequest.isAcceptDataLoss()) {
                    importListener.onFailure((Exception)new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexMetaDataToImport.getIndex().getName();
                final String indexUUID = indexMetaDataToImport.getIndexUUID();
                TransportImportDanglingIndexAction.this.danglingIndexAllocator.allocateDangled(Collections.singletonList(indexMetaDataToImport), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                    public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse allocateDangledResponse) {
                        importListener.onResponse((Object)new AcknowledgedResponse(true));
                    }

                    public void onFailure(Exception e) {
                        logger.debug("Failed to import dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        importListener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + importRequest.getIndexUUID() + "]", (Throwable)e);
                importListener.onFailure(e);
            }
        });
    }

    private void findDanglingIndex(ImportDanglingIndexRequest request, final ActionListener<IndexMetadata> listener) {
        final String indexUUID = request.getIndexUUID();
        this.nodeClient.execute((ActionType)FindDanglingIndexAction.INSTANCE, (ActionRequest)new FindDanglingIndexRequest(indexUUID), (ActionListener)new ActionListener<FindDanglingIndexResponse>(){

            public void onResponse(FindDanglingIndexResponse response) {
                if (response.hasFailures()) {
                    String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                    SkyliteException e = new SkyliteException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                    for (FailedNodeException failure : response.failures()) {
                        logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)failure);
                        e.addSuppressed((Throwable)failure);
                    }
                    listener.onFailure((Exception)e);
                    return;
                }
                ArrayList<IndexMetadata> metaDataSortedByVersion = new ArrayList<IndexMetadata>();
                for (NodeFindDanglingIndexResponse each : response.getNodes()) {
                    metaDataSortedByVersion.addAll(each.getDanglingIndexInfo());
                }
                metaDataSortedByVersion.sort(Comparator.comparingLong(IndexMetadata::getVersion));
                if (metaDataSortedByVersion.isEmpty()) {
                    listener.onFailure((Exception)new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
                    return;
                }
                logger.debug("Metadata versions {} found for index UUID [{}], selecting the highest", metaDataSortedByVersion.stream().map(IndexMetadata::getVersion).collect(Collectors.toList()), (Object)indexUUID);
                listener.onResponse((Object)((IndexMetadata)metaDataSortedByVersion.get(metaDataSortedByVersion.size() - 1)));
            }

            public void onFailure(Exception exp) {
                listener.onFailure(exp);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ImportDanglingIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportImportDanglingIndexAction.class;
        }
    }
}

