/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.dangling.list;

import io.lucenia.action.support.nodes.TransportNodesAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.indices.dangling.DanglingIndexInfo;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesAction;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesRequest;
import io.skylite.core.action.admin.indices.dangling.list.ListDanglingIndicesResponse;
import io.skylite.core.action.admin.indices.dangling.list.NodeListDanglingIndicesRequest;
import io.skylite.core.action.admin.indices.dangling.list.NodeListDanglingIndicesResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensearch.gateway.DanglingIndicesState;

public class TransportListDanglingIndicesAction
extends TransportNodesAction<ListDanglingIndicesRequest, ListDanglingIndicesResponse, NodeListDanglingIndicesRequest, NodeListDanglingIndicesResponse> {
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportListDanglingIndicesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super("cluster:admin/indices/dangling/list", threadPool, clusterService, transportService, actionFilters, ListDanglingIndicesRequest::new, NodeListDanglingIndicesRequest::new, "management", NodeListDanglingIndicesResponse.class);
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected ListDanglingIndicesResponse newResponse(ListDanglingIndicesRequest request, List<NodeListDanglingIndicesResponse> nodeListDanglingIndicesResponse, List<FailedNodeException> failures) {
        return new ListDanglingIndicesResponse(this.clusterService.getClusterName(), nodeListDanglingIndicesResponse, failures);
    }

    @Override
    protected NodeListDanglingIndicesRequest newNodeRequest(ListDanglingIndicesRequest request) {
        return new NodeListDanglingIndicesRequest(request.getIndexUUID());
    }

    @Override
    protected NodeListDanglingIndicesResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodeListDanglingIndicesResponse(in);
    }

    @Override
    protected NodeListDanglingIndicesResponse nodeOperation(NodeListDanglingIndicesRequest request) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        ArrayList<DanglingIndexInfo> indexMetaData = new ArrayList<DanglingIndexInfo>();
        String indexFilter = request.getIndexUUID();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (indexFilter != null && !indexFilter.equals(each.getIndexUUID())) continue;
            DanglingIndexInfo danglingIndexInfo = new DanglingIndexInfo(localNode.getId(), each.getIndex().getName(), each.getIndexUUID(), each.getCreationDate());
            indexMetaData.add(danglingIndexInfo);
        }
        return new NodeListDanglingIndicesResponse(localNode, indexMetaData);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return ListDanglingIndicesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportListDanglingIndicesAction.class;
        }
    }
}

