/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.datastream;

import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.datastream.DeleteDataStreamAction;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.Priority;
import io.skylite.core.common.Strings;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.Index;
import io.skylite.core.snapshots.SnapshotsService;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;
import org.opensearch.snapshots.SnapshotInProgressException;

public class TransportDeleteDataStreamAction
extends TransportClusterManagerNodeAction<DeleteDataStreamAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDataStreamAction.class);
    private final MetadataDeleteIndexService deleteIndexService;
    private final ClusterManagerTaskThrottler.ThrottlingKey removeDataStreamTaskKey;

    @Inject
    public TransportDeleteDataStreamAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDeleteIndexService deleteIndexService) {
        super("indices:admin/data_stream/delete", transportService, clusterService, threadPool, actionFilters, DeleteDataStreamAction.Request::new, indexNameExpressionResolver);
        this.deleteIndexService = deleteIndexService;
        this.removeDataStreamTaskKey = clusterService.registerClusterManagerTask("remove-data-stream", true);
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(final DeleteDataStreamAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        this.clusterService.submitStateUpdateTask("remove-data-stream [" + Strings.arrayToCommaDelimitedString((Object[])request.names()) + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(Priority.HIGH){

            public TimeValue timeout() {
                return request.clusterManagerNodeTimeout();
            }

            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return TransportDeleteDataStreamAction.this.removeDataStreamTaskKey;
            }

            public ClusterState execute(ClusterState currentState) {
                return TransportDeleteDataStreamAction.removeDataStream(TransportDeleteDataStreamAction.this.deleteIndexService, currentState, request);
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        });
    }

    static ClusterState removeDataStream(MetadataDeleteIndexService deleteIndexService, ClusterState currentState, DeleteDataStreamAction.Request request) {
        HashSet<String> dataStreams = new HashSet<String>();
        HashSet snapshottingDataStreams = new HashSet();
        for (String name : request.names()) {
            for (String dataStreamName : currentState.metadata().dataStreams().keySet()) {
                if (!Regex.simpleMatch((String)name, (String)dataStreamName)) continue;
                dataStreams.add(dataStreamName);
            }
            snapshottingDataStreams.addAll(SnapshotsService.snapshottingDataStreams((ClusterState)currentState, dataStreams));
        }
        if (!snapshottingDataStreams.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete data streams that are being snapshotted: " + String.valueOf(snapshottingDataStreams) + ". Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        HashSet<Index> backingIndicesToRemove = new HashSet<Index>();
        for (String dataStreamName : dataStreams) {
            DataStream dataStream = (DataStream)currentState.metadata().dataStreams().get(dataStreamName);
            assert (dataStream != null);
            backingIndicesToRemove.addAll(dataStream.getIndices());
        }
        Metadata.Builder metadata = Metadata.builder((Metadata)currentState.metadata());
        for (String ds : dataStreams) {
            logger.info("removing data stream [{}]", (Object)ds);
            metadata.removeDataStream(ds);
        }
        currentState = ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
        return deleteIndexService.deleteIndices(currentState, backingIndicesToRemove);
    }

    protected ClusterBlockException checkBlock(DeleteDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DeleteDataStreamAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeleteDataStreamAction.class;
        }
    }
}

