/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.delete;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.delete.DeleteIndexAction;
import io.skylite.core.action.admin.indices.delete.DeleteIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.delete.DeleteIndexRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DestructiveOperations;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataDeleteIndexService;

public class TransportDeleteIndexAction
extends TransportClusterManagerNodeAction<DeleteIndexRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteIndexAction.class);
    private final MetadataDeleteIndexService deleteIndexService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportDeleteIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataDeleteIndexService deleteIndexService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/delete", transportService, clusterService, threadPool, actionFilters, DeleteIndexRequest::new, indexNameExpressionResolver);
        this.deleteIndexService = deleteIndexService;
        this.destructiveOperations = destructiveOperations;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void doExecute(Task task, DeleteIndexRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, (ClusterManagerNodeRequest)request, listener);
    }

    protected ClusterBlockException checkBlock(DeleteIndexRequest request, ClusterState state) {
        return state.blocks().indicesAllowReleaseResources(this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected void clusterManagerOperation(DeleteIndexRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        final HashSet<Index> concreteIndices = new HashSet<Index>(Arrays.asList(this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request)));
        if (concreteIndices.isEmpty()) {
            listener.onResponse((Object)new AcknowledgedResponse(true));
            return;
        }
        DeleteIndexClusterStateUpdateRequest deleteRequest = (DeleteIndexClusterStateUpdateRequest)((DeleteIndexClusterStateUpdateRequest)((DeleteIndexClusterStateUpdateRequest)new DeleteIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout())).indices(concreteIndices.toArray(new Index[0]));
        this.deleteIndexService.deleteIndices(deleteRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to delete indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DeleteIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeleteIndexAction.class;
        }
    }
}

