/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.flush;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.admin.indices.flush.FlushRequest;
import io.skylite.core.action.admin.indices.flush.ShardFlushRequest;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportShardFlushAction
extends TransportReplicationAction<ShardFlushRequest, ShardFlushRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/flush[s]";
    private static final String PRE_SYNCED_FLUSH_ACTION_NAME = "internal:indices/flush/synced/pre";

    @Inject
    public TransportShardFlushAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, shardStateAction::remoteShardFailed, actionFilters, ShardFlushRequest::new, ShardFlushRequest::new, "flush");
        transportService.registerRequestHandler(PRE_SYNCED_FLUSH_ACTION_NAME, "flush", PreShardSyncedFlushRequest::new, (TransportRequestHandler)new PreSyncedFlushTransportHandler(indicesService));
    }

    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    protected void shardOperationOnPrimary(ShardFlushRequest shardRequest, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardFlushRequest, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            primary.flush(shardRequest.getRequest());
            this.logger.trace("{} flush request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult((ReplicationRequest)shardRequest, new ReplicationResponse());
        });
    }

    protected void shardOperationOnReplica(ShardFlushRequest request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            replica.flush(request.getRequest());
            this.logger.trace("{} flush request executed on replica", (Object)replica.shardId());
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private static final class PreSyncedFlushTransportHandler
    implements TransportRequestHandler<PreShardSyncedFlushRequest> {
        private final IndicesService indicesService;

        PreSyncedFlushTransportHandler(IndicesService indicesService) {
            this.indicesService = indicesService;
        }

        public void messageReceived(PreShardSyncedFlushRequest request, TransportChannel channel, Task task) {
            IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId.getIndex()).getShard(request.shardId.id());
            indexShard.flush(new FlushRequest(new String[0]).force(false).waitIfOngoing(true));
            throw new UnsupportedOperationException("Synced flush was removed and a normal flush was performed instead.");
        }
    }

    private static class PreShardSyncedFlushRequest
    extends TransportRequest {
        private final ShardId shardId;

        private PreShardSyncedFlushRequest(StreamInput in) throws IOException {
            super(in);
            assert (in.getVersion().before((Version)OpenSearchVersion.V_2_0_0)) : "received pre_sync request from a new node";
            this.shardId = new ShardId(in);
        }

        public String toString() {
            return "PreShardSyncedFlushRequest{shardId=" + String.valueOf(this.shardId) + "}";
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (false) : "must not send pre_sync request from a new node";
            throw new UnsupportedOperationException("");
        }
    }
}

