/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.get.GetIndexAction;
import io.skylite.core.action.admin.indices.get.GetIndexRequest;
import io.skylite.core.action.admin.indices.get.GetIndexResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterInfoAction;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.opensearch.indices.IndicesService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    private final IndicesService indicesService;
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportGetIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/get", transportService, clusterService, threadPool, actionFilters, GetIndexRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexScopedSettings;
    }

    protected GetIndexResponse read(StreamInput in) throws IOException {
        return new GetIndexResponse(in);
    }

    protected void doClusterManagerOperation(GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        Map mappingsResult = Map.of();
        Map aliasesResult = Map.of();
        Map settings = Map.of();
        Map defaultSettings = Map.of();
        HashMap<String, String> dataStreams = new HashMap<String, String>(StreamSupport.stream(Spliterators.spliterator(state.metadata().findDataStreams(concreteIndices).entrySet(), 0), false).collect(Collectors.toMap(k -> (String)k.getKey(), v -> ((IndexAbstraction.DataStream)v.getValue()).getName())));
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        block7: for (GetIndexRequest.Feature feature : features) {
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block7;
                    try {
                        mappingsResult = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter());
                        doneMappings = true;
                        continue block7;
                    }
                    catch (IOException e) {
                        listener.onFailure((Exception)e);
                        return;
                    }
                }
                case ALIASES: {
                    if (doneAliases) continue block7;
                    aliasesResult = state.metadata().findAllAliases(concreteIndices);
                    doneAliases = true;
                    continue block7;
                }
                case SETTINGS: {
                    if (doneSettings) continue block7;
                    HashMap<String, Settings> settingsMapBuilder = new HashMap<String, Settings>();
                    HashMap<String, Settings> defaultSettingsMapBuilder = new HashMap<String, Settings>();
                    for (String index : concreteIndices) {
                        Settings indexSettings = state.metadata().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetadata.addHumanReadableSettings((Settings)indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                        if (!request.includeDefaults()) continue;
                        Settings defaultIndexSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
                        defaultSettingsMapBuilder.put(index, defaultIndexSettings);
                    }
                    settings = settingsMapBuilder;
                    defaultSettings = defaultSettingsMapBuilder;
                    doneSettings = true;
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("feature [" + String.valueOf(feature) + "] is not valid");
                }
            }
        }
        listener.onResponse((Object)new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings, defaultSettings, dataStreams));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetIndexAction.class;
        }
    }
}

