/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.mapping.get;

import io.lucenia.action.admin.indices.mapping.get.TransportGetFieldMappingsIndexAction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsAction;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class TransportGetFieldMappingsAction
extends HandledTransportAction<GetFieldMappingsRequest, GetFieldMappingsResponse> {
    private final ClusterService clusterService;
    private final TransportGetFieldMappingsIndexAction shardAction;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetFieldMappingsAction(TransportService transportService, ClusterService clusterService, TransportGetFieldMappingsIndexAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/mappings/fields/get", transportService, actionFilters, GetFieldMappingsRequest::new);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, GetFieldMappingsRequest request, final ActionListener<GetFieldMappingsResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)request);
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)new GetFieldMappingsResponse(Collections.emptyMap()));
        } else {
            for (String index : concreteIndices) {
                GetFieldMappingsIndexRequest shardRequest = new GetFieldMappingsIndexRequest(request, index);
                this.shardAction.execute((ActionRequest)shardRequest, (ActionListener)new ActionListener<GetFieldMappingsResponse>(){

                    public void onResponse(GetFieldMappingsResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse((Object)TransportGetFieldMappingsAction.this.merge(indexResponses));
                        }
                    }

                    public void onFailure(Exception e) {
                        int index = indexCounter.getAndIncrement();
                        indexResponses.set(index, e);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse((Object)TransportGetFieldMappingsAction.this.merge(indexResponses));
                        }
                    }
                });
            }
        }
    }

    private GetFieldMappingsResponse merge(AtomicReferenceArray<Object> indexResponses) {
        HashMap mergedResponses = new HashMap();
        for (int i = 0; i < indexResponses.length(); ++i) {
            Object element = indexResponses.get(i);
            if (!(element instanceof GetFieldMappingsResponse)) continue;
            GetFieldMappingsResponse response = (GetFieldMappingsResponse)element;
            mergedResponses.putAll(response.mappings());
        }
        return new GetFieldMappingsResponse(Collections.unmodifiableMap(mergedResponses));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetFieldMappingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetFieldMappingsAction.class;
        }

        public Class<?>[] getSupportTransportActions() {
            return new Class[]{TransportGetFieldMappingsIndexAction.class};
        }
    }
}

