/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.mapping.get;

import io.skylite.SkyliteException;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.opensearch.index.IndexService;
import org.opensearch.indices.IndicesService;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleShardAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFieldMappingsIndexRequest::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    protected GetFieldMappingsResponse shardOperation(GetFieldMappingsIndexRequest request, ShardId shardId) {
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        Predicate<String> metadataFieldPredicate = f -> this.indicesService.isMetadataField((String)f);
        Predicate<String> fieldPredicate = metadataFieldPredicate.or(this.indicesService.getFieldFilter().apply(shardId.getIndexName()));
        DocumentMapper documentMapper = indexService.mapperService().documentMapper();
        Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMapping = TransportGetFieldMappingsIndexAction.findFieldMappings(fieldPredicate, documentMapper, request);
        return new GetFieldMappingsResponse(Collections.singletonMap(shardId.getIndexName(), fieldMapping));
    }

    protected Writeable.Reader<GetFieldMappingsResponse> getResponseReader() {
        return GetFieldMappingsResponse::new;
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }

    private static Map<String, GetFieldMappingsResponse.FieldMappingMetadata> findFieldMappings(Predicate<String> fieldPredicate, DocumentMapper documentMapper, GetFieldMappingsIndexRequest request) {
        if (documentMapper == null) {
            return Collections.emptyMap();
        }
        HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings = new HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata>();
        MappingLookup mappingLookup = documentMapper.mappers();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern((String)field)) {
                for (Mapper fieldMapper : mappingLookup.fieldMappers()) {
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern((String)field)) {
                for (Mapper fieldMapper : mappingLookup.fieldMappers()) {
                    if (!Regex.simpleMatch((String)field, (String)fieldMapper.name())) continue;
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            Mapper fieldMapper = mappingLookup.getMapper(field);
            if (fieldMapper == null) continue;
            TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, field, fieldMapper, fieldMappings, request.includeDefaults());
        }
        return Collections.unmodifiableMap(fieldMappings);
    }

    private static void addFieldMapper(Predicate<String> fieldPredicate, String field, Mapper fieldMapper, Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        if (fieldPredicate.test(field)) {
            try {
                BytesReference bytes = XContentHelper.toXContent((ToXContent)fieldMapper, (MediaType)MediaTypeRegistry.JSON, (ToXContent.Params)(includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS), (boolean)false);
                fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetadata(fieldMapper.name(), bytes));
            }
            catch (IOException e) {
                throw new SkyliteException("failed to serialize XContent of field [" + field + "]", (Throwable)e, new Object[0]);
            }
        }
    }
}

