/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.mapping.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsAction;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsRequest;
import io.skylite.core.action.admin.indices.mapping.get.GetMappingsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterInfoAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.indices.IndicesService;

public class TransportGetMappingsAction
extends TransportClusterInfoAction<GetMappingsRequest, GetMappingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetMappingsAction.class);
    private final IndicesService indicesService;

    @Inject
    public TransportGetMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService) {
        super("indices:admin/mappings/get", transportService, clusterService, threadPool, actionFilters, GetMappingsRequest::new, indexNameExpressionResolver);
        this.indicesService = indicesService;
    }

    protected GetMappingsResponse read(StreamInput in) throws IOException {
        return new GetMappingsResponse(in);
    }

    protected void doClusterManagerOperation(GetMappingsRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetMappingsResponse> listener) {
        logger.trace("serving getMapping request based on version {}", (Object)state.version());
        try {
            Map result = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter());
            listener.onResponse((Object)new GetMappingsResponse(result));
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetMappingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetMappingsAction.class;
        }
    }
}

