/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.open;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexAction;
import io.skylite.core.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexRequest;
import io.skylite.core.action.admin.indices.open.OpenIndexResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DestructiveOperations;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.OpenIndexClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataIndexStateService;

public class TransportOpenIndexAction
extends TransportClusterManagerNodeAction<OpenIndexRequest, OpenIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportOpenIndexAction.class);
    private final MetadataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportOpenIndexAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexStateService indexStateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/open", transportService, clusterService, threadPool, actionFilters, OpenIndexRequest::new, indexNameExpressionResolver);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
    }

    protected String executor() {
        return "same";
    }

    protected OpenIndexResponse read(StreamInput in) throws IOException {
        return new OpenIndexResponse(in);
    }

    protected void doExecute(Task task, OpenIndexRequest request, ActionListener<OpenIndexResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, (ClusterManagerNodeRequest)request, listener);
    }

    protected ClusterBlockException checkBlock(OpenIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected void clusterManagerOperation(OpenIndexRequest request, ClusterState state, final ActionListener<OpenIndexResponse> listener) {
        final Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse((Object)new OpenIndexResponse(true, true));
            return;
        }
        OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout())).indices(concreteIndices)).waitForActiveShards(request.waitForActiveShards());
        this.indexStateService.openIndex(updateRequest, new ActionListener<OpenIndexClusterStateUpdateResponse>(){

            public void onResponse(OpenIndexClusterStateUpdateResponse response) {
                listener.onResponse((Object)new OpenIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to open indices [{}]", (Object)concreteIndices), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return OpenIndexAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportOpenIndexAction.class;
        }
    }
}

