/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.readonly;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockAction;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockRequest;
import io.skylite.core.action.admin.indices.readonly.AddIndexBlockResponse;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DestructiveOperations;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.Index;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataIndexStateService;

public class TransportAddIndexBlockAction
extends TransportClusterManagerNodeAction<AddIndexBlockRequest, AddIndexBlockResponse> {
    private static final Logger logger = LogManager.getLogger(TransportAddIndexBlockAction.class);
    private final MetadataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportAddIndexBlockAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexStateService indexStateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DestructiveOperations destructiveOperations) {
        super("indices:admin/block/add", transportService, clusterService, threadPool, actionFilters, AddIndexBlockRequest::new, indexNameExpressionResolver);
        this.indexStateService = indexStateService;
        this.destructiveOperations = destructiveOperations;
    }

    protected String executor() {
        return "same";
    }

    protected AddIndexBlockResponse read(StreamInput in) throws IOException {
        return new AddIndexBlockResponse(in);
    }

    protected void doExecute(Task task, AddIndexBlockRequest request, ActionListener<AddIndexBlockResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(task, (ClusterManagerNodeRequest)request, listener);
    }

    protected ClusterBlockException checkBlock(AddIndexBlockRequest request, ClusterState state) {
        if (request.getBlock().getBlock().levels().contains(ClusterBlockLevel.METADATA_WRITE) && state.blocks().global(ClusterBlockLevel.METADATA_WRITE).isEmpty()) {
            return null;
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected void clusterManagerOperation(AddIndexBlockRequest request, ClusterState state, ActionListener<AddIndexBlockResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    protected void clusterManagerOperation(Task task, AddIndexBlockRequest request, ClusterState state, ActionListener<AddIndexBlockResponse> listener) throws Exception {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse((Object)new AddIndexBlockResponse(true, false, Collections.emptyList()));
            return;
        }
        AddIndexBlockClusterStateUpdateRequest addBlockRequest = (AddIndexBlockClusterStateUpdateRequest)((AddIndexBlockClusterStateUpdateRequest)((AddIndexBlockClusterStateUpdateRequest)new AddIndexBlockClusterStateUpdateRequest(request.getBlock(), task.getId()).ackTimeout(request.timeout())).masterNodeTimeout(request.clusterManagerNodeTimeout())).indices(concreteIndices);
        this.indexStateService.addIndexBlock(addBlockRequest, (ActionListener<AddIndexBlockResponse>)ActionListenerHelper.delegateResponse(listener, (delegatedListener, t) -> {
            logger.debug(() -> new ParameterizedMessage("failed to mark indices as readonly [{}]", (Object)concreteIndices), (Throwable)t);
            delegatedListener.onFailure(t);
        }));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return AddIndexBlockAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportAddIndexBlockAction.class;
        }
    }
}

