/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.readonly;

import io.skylite.common.action.ActionListener;
import io.skylite.common.lease.Releasable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.ReplicationOperation;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.block.ClusterBlock;
import io.skylite.core.cluster.block.ClusterBlocks;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportVerifyShardIndexBlockAction
extends TransportReplicationAction<ShardRequest, ShardRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/block/add[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType("indices:admin/block/add[s]", ReplicationResponse::new);
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    @Inject
    public TransportVerifyShardIndexBlockAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction stateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, stateAction::remoteShardFailed, actionFilters, ShardRequest::new, ShardRequest::new, "management");
    }

    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    protected void acquirePrimaryOperationPermit(BaseIndexShard primary, ShardRequest request, ActionListener<Releasable> onAcquired) {
        ((IndexShard)primary).acquireAllPrimaryOperationsPermits(onAcquired, request.timeout());
    }

    protected void acquireReplicaOperationPermit(BaseIndexShard replica, ShardRequest request, ActionListener<Releasable> onAcquired, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdateOrDeletes) {
        replica.acquireAllReplicaOperationsPermits(primaryTerm, globalCheckpoint, maxSeqNoOfUpdateOrDeletes, onAcquired, request.timeout());
    }

    protected void shardOperationOnPrimary(ShardRequest shardRequest, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardRequest, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, primary);
            return new TransportReplicationAction.PrimaryResult((ReplicationRequest)shardRequest, new ReplicationResponse());
        });
    }

    protected void shardOperationOnReplica(ShardRequest shardRequest, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            this.executeShardOperation(shardRequest, replica);
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    private void executeShardOperation(ShardRequest request, BaseIndexShard indexShard) {
        ShardId shardId = indexShard.shardId();
        if (indexShard.getActiveOperationsCount() != -1) {
            throw new IllegalStateException("index shard " + String.valueOf(shardId) + " is not blocking all operations while waiting for block " + String.valueOf(request.clusterBlock()));
        }
        ClusterBlocks clusterBlocks = this.clusterService.state().blocks();
        if (!clusterBlocks.hasIndexBlock(shardId.getIndexName(), request.clusterBlock())) {
            throw new IllegalStateException("index shard " + String.valueOf(shardId) + " has not applied block " + String.valueOf(request.clusterBlock()));
        }
    }

    public ReplicationOperation.Replicas<ShardRequest> newReplicasProxy() {
        return new VerifyShardReadOnlyActionReplicasProxy();
    }

    public static class ShardRequest
    extends ReplicationRequest<ShardRequest> {
        private final ClusterBlock clusterBlock;

        ShardRequest(StreamInput in) throws IOException {
            super(in);
            this.clusterBlock = new ClusterBlock(in);
        }

        public ShardRequest(ShardId shardId, ClusterBlock clusterBlock, TaskId parentTaskId) {
            super(shardId);
            this.clusterBlock = Objects.requireNonNull(clusterBlock);
            this.setParentTask(parentTaskId);
        }

        public String toString() {
            return "verify shard " + String.valueOf(this.shardId) + " before block with " + String.valueOf(this.clusterBlock);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.clusterBlock.writeTo(out);
        }

        public ClusterBlock clusterBlock() {
            return this.clusterBlock;
        }
    }

    class VerifyShardReadOnlyActionReplicasProxy
    extends TransportReplicationAction.ReplicasProxy {
        VerifyShardReadOnlyActionReplicasProxy() {
            super((TransportReplicationAction)TransportVerifyShardIndexBlockAction.this);
        }

        public void markShardCopyAsStaleIfNeeded(ShardId shardId, String allocationId, long primaryTerm, ActionListener<Void> listener) {
            TransportVerifyShardIndexBlockAction.this.remoteShardFailedAction.execute(shardId, allocationId, primaryTerm, true, "mark copy as stale", null, listener);
        }
    }
}

