/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.refresh;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.BasicReplicationRequest;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.indices.IndicesService;

public class TransportShardRefreshAction
extends TransportReplicationAction<BasicReplicationRequest, BasicReplicationRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/refresh[s]";

    @Inject
    public TransportShardRefreshAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, shardStateAction::remoteShardFailed, actionFilters, BasicReplicationRequest::new, BasicReplicationRequest::new, "refresh");
    }

    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    protected void shardOperationOnPrimary(BasicReplicationRequest shardRequest, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BasicReplicationRequest, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            primary.refresh("api");
            this.logger.trace("{} refresh request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult((ReplicationRequest)shardRequest, new ReplicationResponse());
        });
    }

    protected void shardOperationOnReplica(BasicReplicationRequest request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            replica.refresh("api");
            this.logger.trace("{} refresh request executed on replica", (Object)replica.shardId());
            return new TransportReplicationAction.ReplicaResult();
        });
    }
}

