/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.replication;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationShardStatsResponse;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationStatsAction;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationStatsRequest;
import io.skylite.core.action.admin.indices.replication.SegmentReplicationStatsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.SegmentReplicationPerGroupStats;
import io.skylite.core.index.SegmentReplicationShardStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.replication.SegmentReplicationState;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.index.IndexService;
import org.opensearch.index.SegmentReplicationPressureService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.SegmentReplicationTargetService;

public class TransportSegmentReplicationStatsAction
extends TransportBroadcastByNodeAction<SegmentReplicationStatsRequest, SegmentReplicationStatsResponse, SegmentReplicationShardStatsResponse> {
    private final SegmentReplicationTargetService targetService;
    private final IndicesService indicesService;
    private final SegmentReplicationPressureService pressureService;

    @Inject
    public TransportSegmentReplicationStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, SegmentReplicationTargetService targetService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SegmentReplicationPressureService pressureService) {
        super("indices:monitor/segment_replication", clusterService, transportService, actionFilters, indexNameExpressionResolver, SegmentReplicationStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.targetService = targetService;
        this.pressureService = pressureService;
    }

    @Override
    protected SegmentReplicationShardStatsResponse readShardResult(StreamInput in) throws IOException {
        return new SegmentReplicationShardStatsResponse(in);
    }

    @Override
    protected SegmentReplicationStatsResponse newResponse(SegmentReplicationStatsRequest request, int totalShards, int successfulShards, int failedShards, List<SegmentReplicationShardStatsResponse> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        String[] shards = request.shards();
        List shardsToFetch = Arrays.stream(shards).map(Integer::valueOf).collect(Collectors.toList());
        HashMap<String, SegmentReplicationState> replicaStats = new HashMap<String, SegmentReplicationState>();
        HashMap<String, List> primaryStats = new HashMap<String, List>();
        for (SegmentReplicationShardStatsResponse segmentReplicationShardStatsResponse : responses) {
            if (segmentReplicationShardStatsResponse == null) continue;
            if (segmentReplicationShardStatsResponse.getReplicaStats() != null) {
                ShardRouting shardRouting = segmentReplicationShardStatsResponse.getReplicaStats().getShardRouting();
                if (shardsToFetch.isEmpty() || shardsToFetch.contains(shardRouting.shardId().getId())) {
                    replicaStats.putIfAbsent(shardRouting.allocationId().getId(), segmentReplicationShardStatsResponse.getReplicaStats());
                }
            }
            if (segmentReplicationShardStatsResponse.getPrimaryStats() == null) continue;
            ShardId shardId = segmentReplicationShardStatsResponse.getPrimaryStats().getShardId();
            if (!shardsToFetch.isEmpty() && !shardsToFetch.contains(shardId.getId())) continue;
            primaryStats.compute(shardId.getIndexName(), (k, v) -> {
                if (v == null) {
                    ArrayList<SegmentReplicationPerGroupStats> list = new ArrayList<SegmentReplicationPerGroupStats>();
                    list.add(response.getPrimaryStats());
                    return list;
                }
                v.add(response.getPrimaryStats());
                return v;
            });
        }
        for (Map.Entry entry : primaryStats.entrySet()) {
            for (SegmentReplicationPerGroupStats group : (List)entry.getValue()) {
                for (SegmentReplicationShardStats replicaStat : group.getReplicaStats()) {
                    replicaStat.setCurrentReplicationState((SegmentReplicationState)replicaStats.getOrDefault(replicaStat.getAllocationId(), null));
                }
            }
        }
        return new SegmentReplicationStatsResponse(totalShards, successfulShards, failedShards, primaryStats, shardFailures);
    }

    @Override
    protected SegmentReplicationStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new SegmentReplicationStatsRequest(in);
    }

    @Override
    protected SegmentReplicationShardStatsResponse shardOperation(SegmentReplicationStatsRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        ShardId shardId = shardRouting.shardId();
        if (!indexShard.indexSettings().isSegRepEnabledOrRemoteNode()) {
            return null;
        }
        if (shardRouting.primary()) {
            return new SegmentReplicationShardStatsResponse(this.pressureService.getStatsForShard(indexShard));
        }
        if (request.activeOnly()) {
            return new SegmentReplicationShardStatsResponse(this.targetService.getOngoingEventSegmentReplicationState(shardId));
        }
        return new SegmentReplicationShardStatsResponse(this.targetService.getSegmentReplicationState(shardId));
    }

    @Override
    protected ShardsIterator shards(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.routingTable().allShardsIncludingRelocationTargets(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, SegmentReplicationStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, SegmentReplicationStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return SegmentReplicationStatsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportSegmentReplicationStatsAction.class;
        }
    }
}

