/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.rollover;

import io.lucenia.action.admin.indices.rollover.MetadataRolloverService;
import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.rollover.Condition;
import io.skylite.core.action.admin.indices.rollover.RolloverAction;
import io.skylite.core.action.admin.indices.rollover.RolloverRequest;
import io.skylite.core.action.admin.indices.rollover.RolloverResponse;
import io.skylite.core.action.admin.indices.stats.IndicesStatsAction;
import io.skylite.core.action.admin.indices.stats.IndicesStatsRequest;
import io.skylite.core.action.admin.indices.stats.IndicesStatsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.ActiveShardsObserver;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.service.ClusterManagerTaskThrottler;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateTaskConfig;
import io.skylite.core.cluster.state.ClusterStateUpdateTask;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.shard.DocsStats;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TransportRolloverAction
extends TransportClusterManagerNodeAction<RolloverRequest, RolloverResponse> {
    private final MetadataRolloverService rolloverService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;
    private final ClusterManagerTaskThrottler.ThrottlingKey rolloverIndexTaskKey;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client) {
        super("indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver);
        this.rolloverService = rolloverService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.rolloverIndexTaskKey = clusterService.registerClusterManagerTask("rollover-index", true);
    }

    protected String executor() {
        return "same";
    }

    protected RolloverResponse read(StreamInput in) throws IOException {
        return new RolloverResponse(in);
    }

    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)request.indicesOptions().expandWildcardsOpen(), (boolean)request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, (IndicesRequest)request));
    }

    protected void clusterManagerOperation(RolloverRequest request, ClusterState state, ActionListener<RolloverResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    protected void clusterManagerOperation(Task task, final RolloverRequest rolloverRequest, ClusterState state, final ActionListener<RolloverResponse> listener) throws Exception {
        MetadataRolloverService.RolloverResult preResult = this.rolloverService.rolloverClusterState(state, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), Collections.emptyList(), true, true);
        final Metadata metadata = state.metadata();
        final String sourceIndexName = preResult.sourceIndexName;
        final String rolloverIndexName = preResult.rolloverIndexName;
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getRolloverTarget()})).clear().indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)true))).docs(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)statsRequest, (ActionListener)new ActionListener<IndicesStatsResponse>(){

            public void onResponse(IndicesStatsResponse statsResponse) {
                final Map<String, Boolean> conditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), metadata.index(sourceIndexName), statsResponse);
                if (rolloverRequest.isDryRun()) {
                    listener.onResponse((Object)new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, true, false, false, false));
                    return;
                }
                final List metConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)conditionResults.get(condition.toString())).collect(Collectors.toList());
                if (conditionResults.size() == 0 || metConditions.size() > 0) {
                    TransportRolloverAction.this.clusterService.submitStateUpdateTask("rollover_index source [" + sourceIndexName + "] to target [" + rolloverIndexName + "]", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            MetadataRolloverService.RolloverResult rolloverResult = TransportRolloverAction.this.rolloverService.rolloverClusterState(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), metConditions, false, false);
                            if (!rolloverResult.sourceIndexName.equals(sourceIndexName)) {
                                throw new SkyliteException("Concurrent modification of alias [{}] during rollover", new Object[]{rolloverRequest.getRolloverTarget()});
                            }
                            return rolloverResult.clusterState;
                        }

                        public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                            return TransportRolloverAction.this.rolloverIndexTaskKey;
                        }

                        public void onFailure(String source, Exception e) {
                            listener.onFailure(e);
                        }

                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            if (!newState.equals(oldState)) {
                                TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), rolloverRequest.clusterManagerNodeTimeout(), isShardsAcknowledged -> listener.onResponse((Object)new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, true, isShardsAcknowledged.booleanValue())), arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                            }
                        }
                    });
                } else {
                    listener.onResponse((Object)new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, false, false, false));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable DocsStats docsStats, @Nullable IndexMetadata metadata) {
        if (metadata == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        long numDocs = docsStats == null ? 0L : docsStats.getCount();
        long indexSize = docsStats == null ? 0L : docsStats.getTotalSizeInBytes();
        Condition.Stats stats = new Condition.Stats(numDocs, metadata.getCreationDate(), new ByteSizeValue(indexSize));
        return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition.toString(), result -> result.matched));
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable IndexMetadata metadata, @Nullable IndicesStatsResponse statsResponse) {
        if (metadata == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        DocsStats docsStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metadata.getIndex().getName())).map(indexStats -> indexStats.getPrimaries().getDocs()).orElse(null);
        return TransportRolloverAction.evaluateConditions(conditions, docsStats, metadata);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return RolloverAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportRolloverAction.class;
        }
    }
}

