/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.settings.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.admin.indices.settings.get.GetSettingsAction;
import io.skylite.core.action.admin.indices.settings.get.GetSettingsRequest;
import io.skylite.core.action.admin.indices.settings.get.GetSettingsResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.common.util.CollectionUtils;
import io.skylite.core.index.Index;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsFilter;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;

public class TransportGetSettingsAction
extends TransportClusterManagerNodeReadAction<GetSettingsRequest, GetSettingsResponse> {
    private final SettingsFilter settingsFilter;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportGetSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexedScopedSettings) {
        super("indices:monitor/settings/get", transportService, clusterService, threadPool, actionFilters, GetSettingsRequest::new, indexNameExpressionResolver);
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexedScopedSettings;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(GetSettingsRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request));
    }

    protected GetSettingsResponse read(StreamInput in) throws IOException {
        return new GetSettingsResponse(in);
    }

    private static boolean isFilteredRequest(GetSettingsRequest request) {
        return !CollectionUtils.isEmpty((Object[])request.names());
    }

    protected void clusterManagerOperation(GetSettingsRequest request, ClusterState state, ActionListener<GetSettingsResponse> listener) {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, (IndicesRequest)request);
        HashMap<String, Settings> indexToSettingsBuilder = new HashMap<String, Settings>();
        HashMap<String, Settings> indexToDefaultSettingsBuilder = new HashMap<String, Settings>();
        for (Index concreteIndex : concreteIndices) {
            IndexMetadata indexMetadata = state.getMetadata().index(concreteIndex);
            if (indexMetadata == null) continue;
            Settings indexSettings = this.settingsFilter.filter(indexMetadata.getSettings());
            if (request.humanReadable()) {
                indexSettings = IndexMetadata.addHumanReadableSettings((Settings)indexSettings);
            }
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                indexSettings = indexSettings.filter(k -> Regex.simpleMatch((String[])request.names(), (String)k));
            }
            indexToSettingsBuilder.put(concreteIndex.getName(), indexSettings);
            if (!request.includeDefaults()) continue;
            Settings defaultSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexSettings, Settings.EMPTY));
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                defaultSettings = defaultSettings.filter(k -> Regex.simpleMatch((String[])request.names(), (String)k));
            }
            indexToDefaultSettingsBuilder.put(concreteIndex.getName(), defaultSettings);
        }
        listener.onResponse((Object)new GetSettingsResponse(indexToSettingsBuilder, indexToDefaultSettingsBuilder));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetSettingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetSettingsAction.class;
        }
    }
}

