/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.delete;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import io.skylite.core.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;

public class TransportDeleteIndexTemplateAction
extends TransportClusterManagerNodeAction<DeleteIndexTemplateRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteIndexTemplateAction.class);
    private final MetadataIndexTemplateService indexTemplateService;

    @Inject
    public TransportDeleteIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/template/delete", transportService, clusterService, threadPool, actionFilters, DeleteIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(DeleteIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(final DeleteIndexTemplateRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.indexTemplateService.removeTemplates(new MetadataIndexTemplateService.RemoveRequest(request.name()).clusterManagerTimeout(request.clusterManagerNodeTimeout()), new MetadataIndexTemplateService.RemoveListener(){

            @Override
            public void onResponse(MetadataIndexTemplateService.RemoveResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to delete templates [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return DeleteIndexTemplateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportDeleteIndexTemplateAction.class;
        }
    }
}

