/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.get;

import io.skylite.ResourceNotFoundException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.get.GetComposableIndexTemplateAction;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransportGetComposableIndexTemplateAction
extends TransportClusterManagerNodeReadAction<GetComposableIndexTemplateAction.Request, GetComposableIndexTemplateAction.Response> {
    @Inject
    public TransportGetComposableIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/index_template/get", transportService, clusterService, threadPool, actionFilters, GetComposableIndexTemplateAction.Request::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetComposableIndexTemplateAction.Response read(StreamInput in) throws IOException {
        return new GetComposableIndexTemplateAction.Response(in);
    }

    protected ClusterBlockException checkBlock(GetComposableIndexTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(GetComposableIndexTemplateAction.Request request, ClusterState state, ActionListener<GetComposableIndexTemplateAction.Response> listener) {
        Map allTemplates = state.metadata().templatesV2();
        if (request.name() == null) {
            listener.onResponse((Object)new GetComposableIndexTemplateAction.Response(allTemplates));
            return;
        }
        HashMap<String, ComposableIndexTemplate> results = new HashMap<String, ComposableIndexTemplate>();
        String name = request.name();
        if (Regex.isSimpleMatchPattern((String)name)) {
            for (Map.Entry entry : allTemplates.entrySet()) {
                if (!Regex.simpleMatch((String)name, (String)((String)entry.getKey()))) continue;
                results.put((String)entry.getKey(), (ComposableIndexTemplate)entry.getValue());
            }
        } else if (allTemplates.containsKey(name)) {
            results.put(name, (ComposableIndexTemplate)allTemplates.get(name));
        } else {
            throw new ResourceNotFoundException("index template matching [" + request.name() + "] not found", new Object[0]);
        }
        listener.onResponse((Object)new GetComposableIndexTemplateAction.Response(results));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetComposableIndexTemplateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetComposableIndexTemplateAction.class;
        }
    }
}

