/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.get.GetIndexTemplatesAction;
import io.skylite.core.action.admin.indices.template.get.GetIndexTemplatesRequest;
import io.skylite.core.action.admin.indices.template.get.GetIndexTemplatesResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.IndexTemplateMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TransportGetIndexTemplatesAction
extends TransportClusterManagerNodeReadAction<GetIndexTemplatesRequest, GetIndexTemplatesResponse> {
    @Inject
    public TransportGetIndexTemplatesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/template/get", transportService, clusterService, threadPool, actionFilters, GetIndexTemplatesRequest::new, indexNameExpressionResolver);
    }

    protected String executor() {
        return "same";
    }

    protected GetIndexTemplatesResponse read(StreamInput in) throws IOException {
        return new GetIndexTemplatesResponse(in);
    }

    protected ClusterBlockException checkBlock(GetIndexTemplatesRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void clusterManagerOperation(GetIndexTemplatesRequest request, ClusterState state, ActionListener<GetIndexTemplatesResponse> listener) {
        List<Object> results = request.names().length == 0 ? Arrays.asList(state.metadata().templates().values().toArray(new IndexTemplateMetadata[0])) : new ArrayList();
        for (String name : request.names()) {
            if (Regex.isSimpleMatchPattern((String)name)) {
                for (Map.Entry entry : state.metadata().templates().entrySet()) {
                    if (!Regex.simpleMatch((String)name, (String)((String)entry.getKey()))) continue;
                    results.add((IndexTemplateMetadata)entry.getValue());
                }
                continue;
            }
            if (!state.metadata().templates().containsKey(name)) continue;
            results.add((IndexTemplateMetadata)state.metadata().templates().get(name));
        }
        listener.onResponse((Object)new GetIndexTemplatesResponse(results));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetIndexTemplatesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetIndexTemplatesAction.class;
        }
    }
}

