/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.post;

import io.lucenia.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import io.lucenia.action.admin.indices.template.post.TransportSimulateTemplateAction;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;
import java.util.Objects;

public class SimulateTemplateAction
extends ActionType<SimulateIndexTemplateResponse> {
    public static final SimulateTemplateAction INSTANCE = new SimulateTemplateAction();
    public static final String NAME = "indices:admin/index_template/simulate";

    private SimulateTemplateAction() {
        super(NAME, SimulateIndexTemplateResponse::new);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportSimulateTemplateAction.class;
        }
    }

    public static class Request
    extends ClusterManagerNodeReadRequest<Request> {
        @Nullable
        private String templateName;
        @Nullable
        private PutComposableIndexTemplateAction.Request indexTemplateRequest;

        public Request() {
        }

        public Request(String templateName) {
            if (templateName == null) {
                throw new IllegalArgumentException("template name cannot be null");
            }
            this.templateName = templateName;
        }

        public Request(PutComposableIndexTemplateAction.Request indexTemplateRequest) {
            if (indexTemplateRequest == null) {
                throw new IllegalArgumentException("index template body must be present");
            }
            this.indexTemplateRequest = indexTemplateRequest;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.templateName = in.readOptionalString();
            this.indexTemplateRequest = (PutComposableIndexTemplateAction.Request)in.readOptionalWriteable(PutComposableIndexTemplateAction.Request::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.templateName);
            out.writeOptionalWriteable((Writeable)this.indexTemplateRequest);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indexTemplateRequest != null) {
                validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
            }
            if (this.templateName == null && this.indexTemplateRequest == null) {
                validationException = ValidateActions.addValidationError((String)"either index name or index template body must be specified for simulation", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        @Nullable
        public String getTemplateName() {
            return this.templateName;
        }

        @Nullable
        public PutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
            return this.indexTemplateRequest;
        }

        public Request templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Request indexTemplateRequest(PutComposableIndexTemplateAction.Request indexTemplateRequest) {
            this.indexTemplateRequest = indexTemplateRequest;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return this.templateName.equals(that.templateName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest);
        }

        public int hashCode() {
            return Objects.hash(this.templateName, this.indexTemplateRequest);
        }
    }
}

