/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.post;

import io.lucenia.action.admin.indices.template.post.SimulateIndexTemplateRequest;
import io.lucenia.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import io.skylite.Version;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.AliasMetadata;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.metadata.MetadataIndexTemplateUtility;
import io.skylite.core.cluster.metadata.Template;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.mapper.DocumentMapper;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.indices.IndicesService;

public class TransportSimulateIndexTemplateAction
extends TransportClusterManagerNodeReadAction<SimulateIndexTemplateRequest, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate_index", transportService, clusterService, threadPool, actionFilters, SimulateIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    protected String executor() {
        return "same";
    }

    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    protected void clusterManagerOperation(SimulateIndexTemplateRequest request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        if (request.getIndexTemplateRequest() != null) {
            String simulateTemplateToAdd = "simulate_index_template_" + UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            stateWithTemplate = state;
        }
        String matchingTemplate = MetadataIndexTemplateUtility.findV2Template((Metadata)stateWithTemplate.metadata(), (String)request.getIndexName(), (boolean)false);
        if (matchingTemplate == null) {
            listener.onResponse((Object)new SimulateIndexTemplateResponse(null, null));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState(matchingTemplate, request.getIndexName(), stateWithTemplate);
        ComposableIndexTemplate templateV2 = (ComposableIndexTemplate)tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.getIndexName(), stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, matchingTemplate, templateV2.indexPatterns()));
        listener.onResponse((Object)new SimulateIndexTemplateResponse(template, overlapping));
    }

    protected ClusterBlockException checkBlock(SimulateIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static ClusterState resolveTemporaryState(String matchingTemplate, String indexName, ClusterState simulatedState) {
        Settings settings = MetadataIndexTemplateUtility.resolveSettings((Metadata)simulatedState.metadata(), (String)matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder((String)indexName).settings(dummySettings).build();
        return ClusterState.builder((ClusterState)simulatedState).metadata(Metadata.builder((Metadata)simulatedState.metadata()).put(indexMetadata, true).build()).build();
    }

    public static Template resolveTemplate(String matchingTemplate, String indexName, ClusterState simulatedState, NamedXContentRegistry xContentRegistry, IndicesService indicesService, AliasValidator aliasValidator) throws Exception {
        Settings settings = MetadataIndexTemplateUtility.resolveSettings((Metadata)simulatedState.metadata(), (String)matchingTemplate);
        List<Map<String, AliasMetadata>> resolvedAliases = MetadataIndexTemplateService.resolveAliases(simulatedState.metadata(), matchingTemplate);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata indexMetadata = IndexMetadata.builder((String)indexName).settings(dummySettings).build();
        ClusterState tempClusterState = ClusterState.builder((ClusterState)simulatedState).metadata(Metadata.builder((Metadata)simulatedState.metadata()).put(indexMetadata, true).build()).build();
        List aliases = (List)indicesService.withTempIndexService(indexMetadata, tempIndexService -> MetadataCreateIndexService.resolveAndValidateAliases(indexName, Collections.emptySet(), resolvedAliases, tempClusterState.metadata(), aliasValidator, xContentRegistry, tempIndexService.newQueryShardContext(0, null, () -> 0L, null)));
        Map aliasesByName = aliases.stream().collect(Collectors.toMap(AliasMetadata::getAlias, Function.identity()));
        List<Map<String, Object>> mappings = MetadataCreateIndexService.collectV2Mappings("{}", simulatedState, matchingTemplate, xContentRegistry, indexName);
        CompressedXContent mergedMapping = (CompressedXContent)indicesService.withTempIndexService(indexMetadata, tempIndexService -> {
            MapperService mapperService = tempIndexService.mapperService();
            for (Map mapping : mappings) {
                if (mapping.isEmpty()) continue;
                mapperService.merge("_doc", mapping, MergeReason.INDEX_TEMPLATE);
            }
            DocumentMapper documentMapper = mapperService.documentMapper();
            return documentMapper != null ? documentMapper.mappingSource() : null;
        });
        return new Template(settings, mergedMapping, aliasesByName);
    }
}

