/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.post;

import io.lucenia.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import io.lucenia.action.admin.indices.template.post.SimulateTemplateAction;
import io.lucenia.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.ComposableIndexTemplate;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Template;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.indices.IndicesService;

public class TransportSimulateTemplateAction
extends TransportClusterManagerNodeReadAction<SimulateTemplateAction.Request, SimulateIndexTemplateResponse> {
    private final MetadataIndexTemplateService indexTemplateService;
    private final NamedXContentRegistry xContentRegistry;
    private final IndicesService indicesService;
    private AliasValidator aliasValidator;

    @Inject
    public TransportSimulateTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NamedXContentRegistry xContentRegistry, IndicesService indicesService) {
        super("indices:admin/index_template/simulate", transportService, clusterService, threadPool, actionFilters, SimulateTemplateAction.Request::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.xContentRegistry = xContentRegistry;
        this.indicesService = indicesService;
        this.aliasValidator = new AliasValidator();
    }

    protected String executor() {
        return "same";
    }

    protected SimulateIndexTemplateResponse read(StreamInput in) throws IOException {
        return new SimulateIndexTemplateResponse(in);
    }

    protected void clusterManagerOperation(SimulateTemplateAction.Request request, ClusterState state, ActionListener<SimulateIndexTemplateResponse> listener) throws Exception {
        ClusterState stateWithTemplate;
        Object simulateTemplateToAdd;
        String uuid = UUIDs.randomBase64UUID().toLowerCase(Locale.ROOT);
        String temporaryIndexName = "simulate_template_index_" + uuid;
        if (request.getIndexTemplateRequest() != null) {
            simulateTemplateToAdd = request.getTemplateName() == null ? "simulate_template_" + uuid : request.getTemplateName();
            MetadataIndexTemplateService.validateV2TemplateRequest(state.metadata(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
            stateWithTemplate = this.indexTemplateService.addIndexTemplateV2(state, request.getIndexTemplateRequest().create(), (String)simulateTemplateToAdd, request.getIndexTemplateRequest().indexTemplate());
        } else {
            simulateTemplateToAdd = null;
            stateWithTemplate = state;
        }
        Object matchingTemplate = request.getTemplateName() == null ? simulateTemplateToAdd : request.getTemplateName();
        if (matchingTemplate == null) {
            listener.onFailure((Exception)new IllegalArgumentException("a template name to match or a new template body must be specified"));
            return;
        }
        if (!stateWithTemplate.metadata().templatesV2().containsKey(matchingTemplate)) {
            listener.onFailure((Exception)new IllegalArgumentException("unable to simulate template [" + (String)matchingTemplate + "] that does not exist"));
            return;
        }
        ClusterState tempClusterState = TransportSimulateIndexTemplateAction.resolveTemporaryState((String)matchingTemplate, temporaryIndexName, stateWithTemplate);
        ComposableIndexTemplate templateV2 = (ComposableIndexTemplate)tempClusterState.metadata().templatesV2().get(matchingTemplate);
        assert (templateV2 != null) : "the matched template must exist";
        HashMap<String, List<String>> overlapping = new HashMap<String, List<String>>();
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV1Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        overlapping.putAll(MetadataIndexTemplateService.findConflictingV2Templates(tempClusterState, (String)matchingTemplate, templateV2.indexPatterns()));
        Template template = TransportSimulateIndexTemplateAction.resolveTemplate((String)matchingTemplate, temporaryIndexName, stateWithTemplate, this.xContentRegistry, this.indicesService, this.aliasValidator);
        listener.onResponse((Object)new SimulateIndexTemplateResponse(template, overlapping));
    }

    protected ClusterBlockException checkBlock(SimulateTemplateAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

