/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.template.put;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.template.put.PutIndexTemplateAction;
import io.skylite.core.action.admin.indices.template.put.PutIndexTemplateRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;

public class TransportPutIndexTemplateAction
extends TransportClusterManagerNodeAction<PutIndexTemplateRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutIndexTemplateAction.class);
    private final MetadataIndexTemplateService indexTemplateService;
    private final IndexScopedSettings indexScopedSettings;

    @Inject
    public TransportPutIndexTemplateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataIndexTemplateService indexTemplateService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexScopedSettings) {
        super("indices:admin/template/put", transportService, clusterService, threadPool, actionFilters, PutIndexTemplateRequest::new, indexNameExpressionResolver);
        this.indexTemplateService = indexTemplateService;
        this.indexScopedSettings = indexScopedSettings;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(PutIndexTemplateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void clusterManagerOperation(final PutIndexTemplateRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        Settings.Builder templateSettingsBuilder = Settings.builder();
        templateSettingsBuilder.put(request.settings()).normalizePrefix("index.");
        this.indexScopedSettings.validate(templateSettingsBuilder.build(), true);
        this.indexTemplateService.putTemplate(new MetadataIndexTemplateService.PutRequest(cause, request.name()).patterns(request.patterns()).order(request.order()).settings(templateSettingsBuilder.build()).mappings(request.mappings()).aliases(request.aliases()).create(request.create()).clusterManagerTimeout(request.clusterManagerNodeTimeout()).version(request.version()), new MetadataIndexTemplateService.PutListener(){

            @Override
            public void onResponse(MetadataIndexTemplateService.PutResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug(() -> new ParameterizedMessage("failed to put template [{}]", (Object)request.name()), (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return PutIndexTemplateAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportPutIndexTemplateAction.class;
        }
    }
}

