/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.upgrade.post;

import io.lucenia.action.support.broadcast.node.TransportBroadcastByNodeAction;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.PrimaryMissingActionException;
import io.skylite.core.action.admin.indices.upgrade.post.ShardUpgradeResult;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeAction;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeRequest;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeResponse;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.IndexRoutingTable;
import io.skylite.core.cluster.routing.RoutingTable;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.Version;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportUpgradeAction
extends TransportBroadcastByNodeAction<UpgradeRequest, UpgradeResponse, ShardUpgradeResult> {
    private final IndicesService indicesService;
    private final NodeClient client;

    @Inject
    public TransportUpgradeAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("indices:admin/upgrade", clusterService, transportService, actionFilters, indexNameExpressionResolver, UpgradeRequest::new, "force_merge");
        this.indicesService = indicesService;
        this.client = client;
    }

    @Override
    protected UpgradeResponse newResponse(UpgradeRequest request, int totalShards, int successfulShards, int failedShards, List<ShardUpgradeResult> shardUpgradeResults, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        HashMap<String, Integer> successfulPrimaryShards = new HashMap<String, Integer>();
        HashMap<String, Tuple> versions = new HashMap<String, Tuple>();
        for (ShardUpgradeResult result : shardUpgradeResults) {
            Tuple versionTuple;
            ++successfulShards;
            String index = result.getShardId().getIndex().getName();
            if (result.primary()) {
                Integer count = (Integer)successfulPrimaryShards.get(index);
                successfulPrimaryShards.put(index, count == null ? 1 : count + 1);
            }
            if ((versionTuple = (Tuple)versions.get(index)) == null) {
                versions.put(index, new Tuple((Object)result.upgradeVersion(), (Object)result.oldestLuceneSegment()));
                continue;
            }
            io.skylite.Version version = (io.skylite.Version)versionTuple.v1();
            Version luceneVersion = (Version)versionTuple.v2();
            if (result.upgradeVersion().after((io.skylite.Version)versionTuple.v1())) {
                version = result.upgradeVersion();
            }
            if (!result.oldestLuceneSegment().onOrAfter((Version)versionTuple.v2())) {
                luceneVersion = result.oldestLuceneSegment();
            }
            versions.put(index, new Tuple((Object)version, (Object)luceneVersion));
        }
        HashMap<String, Tuple> updatedVersions = new HashMap<String, Tuple>();
        Metadata metadata = clusterState.metadata();
        for (Map.Entry versionEntry : versions.entrySet()) {
            String index = (String)versionEntry.getKey();
            Integer primaryCount = (Integer)successfulPrimaryShards.get(index);
            int expectedPrimaryCount = metadata.index(index).getNumberOfShards();
            if (primaryCount.intValue() == metadata.index(index).getNumberOfShards()) {
                updatedVersions.put(index, new Tuple((Object)((io.skylite.Version)((Tuple)versionEntry.getValue()).v1()), (Object)((Version)((Tuple)versionEntry.getValue()).v2()).toString()));
                continue;
            }
            this.logger.warn("Not updating settings for the index [{}] because upgraded of some primary shards failed - expected[{}], received[{}]", (Object)index, (Object)expectedPrimaryCount, (Object)(primaryCount == null ? 0 : primaryCount));
        }
        return new UpgradeResponse(updatedVersions, totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ShardUpgradeResult shardOperation(UpgradeRequest request, ShardRouting shardRouting) throws IOException {
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
        Version oldestLuceneSegment = indexShard.upgrade(request);
        return new ShardUpgradeResult(shardRouting.shardId(), indexShard.routingEntry().primary(), io.skylite.Version.CURRENT, oldestLuceneSegment);
    }

    @Override
    protected ShardUpgradeResult readShardResult(StreamInput in) throws IOException {
        return new ShardUpgradeResult(in);
    }

    @Override
    protected UpgradeRequest readRequestFrom(StreamInput in) throws IOException {
        return new UpgradeRequest(in);
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, UpgradeRequest request, String[] concreteIndices) {
        ShardsIterator iterator = clusterState.routingTable().allShards(concreteIndices);
        Set<String> indicesWithMissingPrimaries = this.indicesWithMissingPrimaries(clusterState, concreteIndices);
        if (indicesWithMissingPrimaries.isEmpty()) {
            return iterator;
        }
        throw new PrimaryMissingActionException("Cannot upgrade indices because the following indices are missing primary shards " + String.valueOf(indicesWithMissingPrimaries));
    }

    private Set<String> indicesWithMissingPrimaries(ClusterState clusterState, String[] concreteIndices) {
        HashSet<String> indices = new HashSet<String>();
        RoutingTable routingTable = clusterState.routingTable();
        for (String index : concreteIndices) {
            IndexRoutingTable indexRoutingTable = routingTable.index(index);
            if (indexRoutingTable.allPrimaryShardsActive()) continue;
            indices.add(index);
        }
        return indices;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, UpgradeRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, UpgradeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }

    @Override
    protected void doExecute(Task task, UpgradeRequest request, ActionListener<UpgradeResponse> listener) {
        super.doExecute(task, request, ActionListenerHelper.wrap(upgradeResponse -> {
            if (upgradeResponse.versions().isEmpty()) {
                listener.onResponse(upgradeResponse);
            } else {
                this.updateSettings((UpgradeResponse)upgradeResponse, listener);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void updateSettings(UpgradeResponse upgradeResponse, ActionListener<UpgradeResponse> listener) {
        UpgradeSettingsRequest upgradeSettingsRequest = new UpgradeSettingsRequest(upgradeResponse.versions());
        this.client.executeLocally((ActionType)UpgradeSettingsAction.INSTANCE, (ActionRequest)upgradeSettingsRequest, ActionListenerHelper.delegateFailure(listener, (delegatedListener, updateSettingsResponse) -> delegatedListener.onResponse((Object)upgradeResponse)));
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return UpgradeAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportUpgradeAction.class;
        }
    }
}

