/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.admin.indices.upgrade.post;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeSettingsAction;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import io.skylite.core.action.admin.indices.upgrade.post.UpgradeSettingsRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateUpdateResponse;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.MetadataUpdateSettingsService;

public class TransportUpgradeSettingsAction
extends TransportClusterManagerNodeAction<UpgradeSettingsRequest, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportUpgradeSettingsAction.class);
    private final MetadataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpgradeSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataUpdateSettingsService updateSettingsService, IndexNameExpressionResolver indexNameExpressionResolver, ActionFilters actionFilters) {
        super("internal:indices/admin/upgrade", transportService, clusterService, threadPool, actionFilters, UpgradeSettingsRequest::new, indexNameExpressionResolver);
        this.updateSettingsService = updateSettingsService;
    }

    protected String executor() {
        return "same";
    }

    protected ClusterBlockException checkBlock(UpgradeSettingsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected void clusterManagerOperation(final UpgradeSettingsRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        UpgradeSettingsClusterStateUpdateRequest clusterStateUpdateRequest = (UpgradeSettingsClusterStateUpdateRequest)((UpgradeSettingsClusterStateUpdateRequest)new UpgradeSettingsClusterStateUpdateRequest().ackTimeout(request.timeout())).versions(request.versions()).masterNodeTimeout(request.clusterManagerNodeTimeout());
        this.updateSettingsService.upgradeIndexSettings(clusterStateUpdateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()));
            }

            public void onFailure(Exception t) {
                logger.debug(() -> new ParameterizedMessage("failed to upgrade minimum compatibility version settings on indices [{}]", request.versions().keySet()), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return UpgradeSettingsAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportUpgradeSettingsAction.class;
        }
    }
}

