/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.bulk;

import io.lucenia.action.bulk.BulkPrimaryExecutionContext;
import io.lucenia.action.bulk.MappingUpdatePerformer;
import io.lucenia.action.update.UpdateHelper;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.common.collect.Tuple;
import io.skylite.common.lease.Releasable;
import io.skylite.common.telemetry.tracing.Tracer;
import io.skylite.common.transport.TransportRequestOptions;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.concurrent.AbstractRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.ActionListenerResponseHandler;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.bulk.BulkAction;
import io.skylite.core.action.bulk.BulkItemRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkShardRequest;
import io.skylite.core.action.bulk.BulkShardResponse;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.replication.ReplicationTask;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.action.support.replication.ReplicatedWriteRequest;
import io.skylite.core.action.support.replication.ReplicationMode;
import io.skylite.core.action.support.replication.ReplicationOperation;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.action.support.replication.TransportWriteAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.transport.NoNodeAvailableException;
import io.skylite.core.cluster.action.index.MappingUpdatedAction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.cluster.state.ClusterStateObserver;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.pressure.IndexingPressureService;
import io.skylite.core.index.remote.RemoteStorePressureService;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardNotFoundException;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.indices.SystemIndices;
import io.skylite.core.mapper.MapperException;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.MessageSupplier;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.index.IndexService;
import org.opensearch.index.SegmentReplicationPressureService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private static final Function<BaseIndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final SegmentReplicationPressureService segmentReplicationPressureService;
    private final RemoteStorePressureService remoteStorePressureService;
    private final String transportPrimaryTermValidationAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SegmentReplicationPressureService segmentReplicationPressureService, RemoteStorePressureService remoteStorePressureService, SystemIndices systemIndices, Tracer tracer) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService::indexServiceSafe, threadPool, shardStateAction::remoteShardFailed, actionFilters, BulkShardRequest::new, BulkShardRequest::new, EXECUTOR_NAME_FUNCTION, false, indexingPressureService, systemIndices, tracer);
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.segmentReplicationPressureService = segmentReplicationPressureService;
        this.remoteStorePressureService = remoteStorePressureService;
        this.transportPrimaryTermValidationAction = "indices:data/write/bulk[s][validate_primary_term]";
        transportService.registerRequestHandler(this.transportPrimaryTermValidationAction, this.executor, true, true, PrimaryTermValidationRequest::new, this::handlePrimaryTermValidationRequest);
    }

    protected void handlePrimaryTermValidationRequest(PrimaryTermValidationRequest request, TransportChannel channel, Task task) {
        ChannelActionListener listener = new ChannelActionListener(channel, this.transportPrimaryTermValidationAction, (TransportRequest)request);
        ShardId shardId = request.getShardId();
        assert (shardId != null) : "request shardId must be set";
        IndexService indexService = (IndexService)this.indexServiceProvider.apply(shardId.getIndex());
        IndexShard replica = indexService.getShard(shardId.id());
        try {
            new PrimaryTermValidationReplicaAction((ActionListener<TransportReplicationAction.ReplicaResponse>)listener, replica, (ReplicationTask)task, request).run();
        }
        catch (RuntimeException e) {
            listener.onFailure((Exception)e);
        }
    }

    protected ReplicationOperation.Replicas<BulkShardRequest> primaryTermValidationReplicasProxy() {
        return new PrimaryTermValidationProxy();
    }

    protected TransportRequestOptions transportOptions(Settings settings) {
        return BulkAction.INSTANCE.transportOptions(settings);
    }

    protected BulkShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new BulkShardResponse(in);
    }

    protected void dispatchedShardOperationOnPrimary(BulkShardRequest request, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, () -> ((ThreadPool)this.threadPool).absoluteTimeInMillis(), (update, shardId, mappingListener) -> {
            assert (update != null);
            assert (shardId != null);
            this.mappingUpdatedAction.updateMappingOnClusterManager(shardId.getIndex(), update, mappingListener);
        }, mappingUpdateListener -> observer.waitForNextChange(new ClusterStateObserver.Listener(){
            final /* synthetic */ ActionListener val$mappingUpdateListener;
            {
                this.val$mappingUpdateListener = actionListener;
            }

            public void onNewClusterState(ClusterState state) {
                this.val$mappingUpdateListener.onResponse(null);
            }

            public void onClusterServiceClose() {
                this.val$mappingUpdateListener.onFailure((Exception)new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode()));
            }

            public void onTimeout(TimeValue timeout) {
                this.val$mappingUpdateListener.onFailure((Exception)new MapperException("timed out while waiting for a dynamic mapping update"));
            }
        }), listener, this.threadPool, this.executor(primary));
    }

    protected long primaryOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    public ReplicationMode getReplicationMode(BaseIndexShard indexShard) {
        if (indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return ReplicationMode.PRIMARY_TERM_VALIDATION;
        }
        return super.getReplicationMode(indexShard);
    }

    public static void performOnPrimary(final BulkShardRequest request, final BaseIndexShard primary, final UpdateHelper updateHelper, final LongSupplier nowInMillisSupplier, final MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, final ThreadPool threadPool, final String executorName) {
        new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(listener){
            private final Executor executor;
            private final BulkPrimaryExecutionContext context;
            {
                super(listener);
                this.executor = threadPool.executor(executorName);
                this.context = new BulkPrimaryExecutionContext(request, primary);
            }

            public void doRun() throws Exception {
                while (this.context.hasMoreOperationsToExecute()) {
                    if (!TransportShardBulkAction.executeBulkItemRequest(this.context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, (ActionListener<Void>)ActionListenerHelper.wrap(v -> this.executor.execute((Runnable)((Object)this)), this::onRejection))) {
                        return;
                    }
                    assert (this.context.isInitial());
                }
                this.finishRequest();
            }

            public void onRejection(final Exception e) {
                this.executor.execute((Runnable)new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(this.listener){

                    public void doRun() {
                        while (context.hasMoreOperationsToExecute()) {
                            context.setRequestToExecute(context.getCurrent());
                            Object docWriteRequest = context.getRequestToExecute();
                            TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, (IndexShard)primary, docWriteRequest.opType() == DocWriteRequest.OpType.DELETE, docWriteRequest.version()), context, null);
                        }
                        this.finishRequest();
                    }

                    public boolean isForceExecution() {
                        return true;
                    }
                });
            }

            private void finishRequest() {
                ActionListenerHelper.completeWith((ActionListener)this.listener, () -> new TransportWriteAction.WritePrimaryResult((ReplicatedWriteRequest)this.context.getBulkShardRequest(), (ReplicationResponse)this.context.buildShardResponse(), this.context.getLocationToSync(), null, (BaseIndexShard)this.context.getPrimary(), logger));
            }
        }.run();
    }

    protected Releasable checkPrimaryLimits(BulkShardRequest request, boolean rerouteWasLocal, boolean localRerouteInitiatedByNodeClient) {
        if (!this.force((ReplicatedWriteRequest)request)) {
            if (this.segmentReplicationPressureService.isSegmentReplicationBackpressureEnabled()) {
                this.segmentReplicationPressureService.isSegrepLimitBreached(request.shardId());
            }
            if (this.remoteStorePressureService.isSegmentsUploadBackpressureEnabled()) {
                this.remoteStorePressureService.validateSegmentsUploadLag(request.shardId());
            }
        }
        return super.checkPrimaryLimits((ReplicatedWriteRequest)request, rerouteWasLocal, localRerouteInitiatedByNodeClient);
    }

    static boolean executeBulkItemRequest(final BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, final ActionListener<Void> itemDoneListener) throws Exception {
        EngineResult.DeleteResult result;
        boolean isDelete;
        UpdateHelper.Result updateResult;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier);
            }
            catch (Exception failure) {
                EngineResult.IndexResult result2 = new EngineResult.IndexResult(failure, updateRequest.version());
                context.setRequestToExecute((DocWriteRequest)updateRequest);
                context.markOperationAsExecuted((EngineResult)result2);
                context.markAsCompleted(context.getExecutionResult());
                return true;
            }
            switch (updateResult.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.action();
                    IndexMetadata metadata = context.getPrimary().indexSettings().getIndexMetadata();
                    MappingMetadata mappingMd = metadata.mapping();
                    indexRequest.process(metadata.getCreationVersion(), mappingMd, updateRequest.concreteIndex());
                    context.setRequestToExecute((DocWriteRequest)indexRequest);
                    break;
                }
                case DELETED: {
                    context.setRequestToExecute((DocWriteRequest)updateResult.action());
                    break;
                }
                case NOOP: {
                    context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                    context.markAsCompleted(context.getExecutionResult());
                    return true;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + String.valueOf(updateResult.getResponseResult()));
                }
            }
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        final IndexShard primary = context.getPrimary();
        final long version = context.getRequestToExecute().version();
        boolean bl = isDelete = context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE;
        if (isDelete) {
            request = (DeleteRequest)context.getRequestToExecute();
            result = primary.applyDeleteOperationOnPrimary(version, request.id(), request.versionType(), request.ifSeqNo(), request.ifPrimaryTerm());
        } else {
            request = (IndexRequest)context.getRequestToExecute();
            result = primary.applyIndexOperationOnPrimary(version, request.versionType(), new SourceToParse(request.index(), request.id(), request.source(), request.getContentType(), request.routing()), request.ifSeqNo(), request.ifPrimaryTerm(), request.getAutoGeneratedTimestamp(), request.isRetry());
        }
        if (result.getResultType() == EngineResult.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                primary.mapperService().merge("_doc", new CompressedXContent(result.getRequiredMappingUpdate()), MergeReason.MAPPING_UPDATE_PREFLIGHT);
            }
            catch (Exception e) {
                logger.info(() -> new ParameterizedMessage("{} mapping update rejected by primary", (Object)primary.shardId()), (Throwable)e);
                TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                return true;
            }
            mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), primary.shardId(), new ActionListener<Void>(){

                public void onResponse(Void v) {
                    context.markAsRequiringMappingUpdate();
                    waitForMappingUpdate.accept(ActionListenerHelper.runAfter((ActionListener)new ActionListener<Void>(){

                        public void onResponse(Void v) {
                            assert (context.requiresWaitingForMappingUpdate());
                            context.resetForExecutionForRetry();
                        }

                        public void onFailure(Exception e) {
                            context.failOnMappingUpdate(e);
                        }
                    }, () -> itemDoneListener.onResponse(null)));
                }

                public void onFailure(Exception e) {
                    TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                    assert (context.isInitial());
                    itemDoneListener.onResponse(null);
                }
            });
            return false;
        }
        TransportShardBulkAction.onComplete((EngineResult)result, context, updateResult);
        return true;
    }

    private static EngineResult exceptionToResult(Exception e, IndexShard primary, boolean isDelete, long version) {
        return isDelete ? primary.getFailedDeleteResult(e, version) : primary.getFailedIndexResult(e, version);
    }

    private static void onComplete(EngineResult r, BulkPrimaryExecutionContext context, UpdateHelper.Result updateResult) {
        BulkItemResponse response;
        context.markOperationAsExecuted(r);
        DocWriteRequest<?> docWriteRequest = context.getCurrent();
        DocWriteRequest.OpType opType = docWriteRequest.opType();
        boolean isUpdate = opType == DocWriteRequest.OpType.UPDATE;
        BulkItemResponse executionResult = context.getExecutionResult();
        boolean isFailed = executionResult.isFailed();
        if (isUpdate && isFailed && TransportShardBulkAction.isConflictException(executionResult.getFailure().getCause()) && context.getRetryCounter() < ((UpdateRequest)docWriteRequest).retryOnConflict()) {
            context.resetForExecutionForRetry();
            return;
        }
        if (isUpdate) {
            response = TransportShardBulkAction.processUpdateResponse((UpdateRequest)docWriteRequest, context.getConcreteIndex(), executionResult, updateResult);
        } else {
            if (isFailed) {
                Exception failure = executionResult.getFailure().getCause();
                MessageSupplier messageSupplier = () -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{context.getPrimary().shardId(), opType.getLowercase(), docWriteRequest});
                if (TransportShardBulkAction.isConflictException(failure)) {
                    logger.trace(messageSupplier, (Throwable)failure);
                } else {
                    logger.debug(messageSupplier, (Throwable)failure);
                }
            }
            response = executionResult;
        }
        context.markAsCompleted(response);
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return SkyliteExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException;
    }

    static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        if (operationResponse.isFailed()) {
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            DocWriteResponse.Result translatedResult = translate.getResponseResult();
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource()) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple sourceAndContent = XContentHelper.convertToMap((BytesReference)indexSourceAsBytes, (boolean)true, (MediaType)updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), (Map)sourceAndContent.v2(), (MediaType)sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + String.valueOf(translatedResult));
            }
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, (DocWriteResponse)updateResponse);
        }
        return response;
    }

    protected void dispatchedShardOperationOnReplica(BulkShardRequest request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            TranslogLocation location = TransportShardBulkAction.performOnReplica(request, (IndexShard)replica);
            return new TransportWriteAction.WriteReplicaResult((ReplicatedWriteRequest)request, location, null, replica, logger);
        });
    }

    protected long replicaOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    public static TranslogLocation performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        TranslogLocation location = null;
        for (int i = 0; i < request.items().length; ++i) {
            EngineResult operationResult;
            BulkItemRequest item = request.items()[i];
            BulkItemResponse response = item.getPrimaryResponse();
            if (item.getPrimaryResponse().isFailed()) {
                if (response.getFailure().getSeqNo() == -2L) continue;
                long primaryTerm = response.getFailure().getTerm() == 0L ? replica.getOperationPrimaryTerm() : response.getFailure().getTerm();
                operationResult = replica.markSeqNoAsNoop(response.getFailure().getSeqNo(), primaryTerm, response.getFailure().getMessage());
            } else {
                if (response.getResponse().getResult() == DocWriteResponse.Result.NOOP) continue;
                assert (response.getResponse().getSeqNo() != -2L);
                operationResult = TransportShardBulkAction.performOpOnReplica(response.getResponse(), item.request(), replica);
            }
            assert (operationResult != null) : "operation result must never be null when primary response has no failure";
            location = TransportShardBulkAction.syncOperationResultOrThrow((EngineResult)operationResult, location);
        }
        return location;
    }

    private static EngineResult performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest<?> docWriteRequest, IndexShard replica) throws Exception {
        EngineResult.DeleteResult result = switch (docWriteRequest.opType()) {
            case DocWriteRequest.OpType.CREATE, DocWriteRequest.OpType.INDEX -> {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = new SourceToParse(shardId.getIndexName(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType(), indexRequest.routing());
                yield replica.applyIndexOperationOnReplica(primaryResponse.getId(), primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
            }
            case DocWriteRequest.OpType.DELETE -> {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                yield replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), deleteRequest.id());
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected request operation type on replica: " + String.valueOf(docWriteRequest) + ";primary result: " + String.valueOf(primaryResponse)));
                }
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        };
        if (result.getResultType() == EngineResult.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }

    protected static final class PrimaryTermValidationRequest
    extends TransportRequest {
        private final String targetAllocationID;
        private final long primaryTerm;
        private final ShardId shardId;

        public PrimaryTermValidationRequest(String targetAllocationID, long primaryTerm, ShardId shardId) {
            this.targetAllocationID = Objects.requireNonNull(targetAllocationID);
            this.primaryTerm = primaryTerm;
            this.shardId = Objects.requireNonNull(shardId);
        }

        public PrimaryTermValidationRequest(StreamInput in) throws IOException {
            super(in);
            this.targetAllocationID = in.readString();
            this.primaryTerm = in.readVLong();
            this.shardId = new ShardId(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.targetAllocationID);
            out.writeVLong(this.primaryTerm);
            this.shardId.writeTo(out);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getTargetAllocationID() {
            return this.targetAllocationID;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "PrimaryTermValidationRequest [" + String.valueOf(this.shardId) + "] for targetAllocationID [" + this.targetAllocationID + "] with primaryTerm [" + this.primaryTerm + "]";
        }
    }

    private static final class PrimaryTermValidationReplicaAction
    extends AbstractRunnable
    implements ActionListener<Releasable> {
        private final ActionListener<TransportReplicationAction.ReplicaResponse> onCompletionListener;
        private final IndexShard replica;
        private final ReplicationTask task;
        private final PrimaryTermValidationRequest request;

        public PrimaryTermValidationReplicaAction(ActionListener<TransportReplicationAction.ReplicaResponse> onCompletionListener, IndexShard replica, ReplicationTask task, PrimaryTermValidationRequest request) {
            this.onCompletionListener = onCompletionListener;
            this.replica = replica;
            this.task = task;
            this.request = request;
        }

        public void onResponse(Releasable releasable) {
            TransportShardBulkAction.setPhase((ReplicationTask)this.task, (String)"finished");
            this.onCompletionListener.onResponse((Object)new TransportReplicationAction.ReplicaResponse(-1L, -1L));
        }

        public void onFailure(Exception e) {
            TransportShardBulkAction.setPhase((ReplicationTask)this.task, (String)"failed");
            this.onCompletionListener.onFailure(e);
        }

        public void doRun() throws Exception {
            TransportShardBulkAction.setPhase((ReplicationTask)this.task, (String)"primary-term-validation");
            String actualAllocationId = this.replica.routingEntry().allocationId().getId();
            if (!actualAllocationId.equals(this.request.getTargetAllocationID())) {
                throw new ShardNotFoundException(this.replica.shardId(), "expected allocation id [{}] but found [{}]", new Object[]{this.request.getTargetAllocationID(), actualAllocationId});
            }
            if (this.request.getPrimaryTerm() < this.replica.getOperationPrimaryTerm()) {
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.request.getShardId(), this.request.getPrimaryTerm(), this.replica.getOperationPrimaryTerm());
                this.onFailure(new IllegalStateException(message));
            } else {
                this.onResponse(null);
            }
        }
    }

    private final class PrimaryTermValidationProxy
    extends TransportWriteAction.WriteActionReplicasProxy {
        private PrimaryTermValidationProxy() {
            super((TransportWriteAction)TransportShardBulkAction.this);
        }

        public void performOn(ShardRouting replica, BulkShardRequest request, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
            String nodeId = replica.currentNodeId();
            DiscoveryNode node = TransportShardBulkAction.this.clusterService.state().nodes().get(nodeId);
            if (node == null) {
                listener.onFailure((Exception)new NoNodeAvailableException("unknown node [" + nodeId + "]"));
                return;
            }
            PrimaryTermValidationRequest validationRequest = new PrimaryTermValidationRequest(replica.allocationId().getId(), primaryTerm, replica.shardId());
            ActionListenerResponseHandler handler = new ActionListenerResponseHandler(listener, TransportReplicationAction.ReplicaResponse::new);
            TransportShardBulkAction.this.transportService.sendRequest(node, TransportShardBulkAction.this.transportPrimaryTermValidationAction, (TransportRequest)validationRequest, TransportShardBulkAction.this.transportOptions, (TransportResponseHandler)handler);
        }
    }
}

