/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.fieldcaps;

import io.lucenia.action.fieldcaps.TransportFieldCapabilitiesAction;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.action.ActionRunnable;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.NoShardAvailableActionException;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesAction;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesIndexRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesIndexResponse;
import io.skylite.core.action.fieldcaps.IndexFieldCapabilities;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.ChannelActionListener;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.TransportActions;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.FailAwareWeightedRouting;
import io.skylite.core.cluster.routing.GroupShardsIterator;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardsIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.logging.LoggerMessageFormat;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.search.BaseSearchService;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.internal.AliasFilter;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.tasks.Task;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.indices.IndicesService;

public class TransportFieldCapabilitiesIndexAction
extends HandledTransportAction<FieldCapabilitiesIndexRequest, FieldCapabilitiesIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportFieldCapabilitiesIndexAction.class);
    private static final String ACTION_NAME = "indices:data/read/field_caps[index]";
    private static final String ACTION_SHARD_NAME = "indices:data/read/field_caps[index][s]";
    public static final ActionType<FieldCapabilitiesIndexResponse> TYPE = new ActionType("indices:data/read/field_caps[index]", FieldCapabilitiesIndexResponse::new);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final BaseSearchService searchService;
    private final IndicesService indicesService;
    private final Executor executor;

    @Inject
    public TransportFieldCapabilitiesIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, BaseSearchService searchService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, transportService, actionFilters, FieldCapabilitiesIndexRequest::new);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.searchService = searchService;
        this.indicesService = indicesService;
        this.executor = threadPool.executor("management");
        transportService.registerRequestHandler(ACTION_SHARD_NAME, "same", FieldCapabilitiesIndexRequest::new, (TransportRequestHandler)new ShardTransportHandler());
    }

    protected void doExecute(Task task, FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
        new AsyncShardsAction(request, listener).start();
    }

    private FieldCapabilitiesIndexResponse shardOperation(FieldCapabilitiesIndexRequest request) throws IOException {
        if (!this.canMatchShard(request)) {
            return new FieldCapabilitiesIndexResponse(request.index(), Collections.emptyMap(), false);
        }
        ShardId shardId = request.shardId();
        MapperService mapperService = this.indicesService.indexServiceSafe(shardId.getIndex()).mapperService();
        HashSet fieldNames = new HashSet();
        for (String field : request.fields()) {
            fieldNames.addAll(mapperService.simpleMatchToFullName(field));
        }
        Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
        HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
        for (String field : fieldNames) {
            String parentField;
            MappedFieldType ft = mapperService.fieldType(field);
            if (ft == null || !this.indicesService.isMetadataField(field) && !fieldPredicate.test(ft.name())) continue;
            IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.familyTypeName(), ft.isSearchable(), ft.isAggregatable(), ft.meta());
            responseMap.put(field, fieldCap);
            int dotIndex = ft.name().lastIndexOf(46);
            while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                if (mapperService.fieldType(parentField) == null) {
                    ObjectMapper mapper = mapperService.getObjectMapper(parentField);
                    String type = mapper.isNested() ? "nested" : "object";
                    IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, Collections.emptyMap());
                    responseMap.put(parentField, fieldCap2);
                }
                dotIndex = parentField.lastIndexOf(46);
            }
        }
        return new FieldCapabilitiesIndexResponse(request.index(), responseMap, true);
    }

    private boolean canMatchShard(FieldCapabilitiesIndexRequest req) throws IOException {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        assert (req.nowInMillis() != 0L);
        ShardSearchRequest searchRequest = new ShardSearchRequest(req.shardId(), req.nowInMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return this.searchService.canMatch(searchRequest).canMatch();
    }

    private ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    private ClusterBlockException checkRequestBlock(ClusterState state, String concreteIndex) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, concreteIndex);
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesIndexRequest> {
        private ShardTransportHandler() {
        }

        public void messageReceived(FieldCapabilitiesIndexRequest request, TransportChannel channel, Task task) throws Exception {
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}]", (Object)request);
            }
            ChannelActionListener listener = new ChannelActionListener(channel, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, (TransportRequest)request);
            TransportFieldCapabilitiesIndexAction.this.executor.execute((Runnable)ActionRunnable.supply((ActionListener)listener, () -> TransportFieldCapabilitiesIndexAction.this.shardOperation(request)));
        }
    }

    class AsyncShardsAction {
        private final FieldCapabilitiesIndexRequest request;
        private final DiscoveryNodes nodes;
        private final ActionListener<FieldCapabilitiesIndexResponse> listener;
        private final GroupShardsIterator<ShardIterator> shardsIt;
        private volatile int shardIndex = 0;

        private AsyncShardsAction(FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
            this.listener = listener;
            ClusterState clusterState = TransportFieldCapabilitiesIndexAction.this.clusterService.state();
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}] based on cluster state version [{}]", (Object)request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = TransportFieldCapabilitiesIndexAction.this.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            this.request = request;
            blockException = TransportFieldCapabilitiesIndexAction.this.checkRequestBlock(clusterState, request.index());
            if (blockException != null) {
                throw blockException;
            }
            this.shardsIt = TransportFieldCapabilitiesIndexAction.this.clusterService.operationRouting().searchShards(TransportFieldCapabilitiesIndexAction.this.clusterService.state(), new String[]{request.index()}, null, null, null, null);
        }

        public void start() {
            this.tryNext(null, true);
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, (Object)this.request), (Throwable)e);
            }
            this.tryNext(e, false);
        }

        private ShardRouting nextRoutingOrNull(Exception failure) {
            if (this.shardsIt.size() == 0 || this.shardIndex >= this.shardsIt.size()) {
                return null;
            }
            ShardRouting next = FailAwareWeightedRouting.getInstance().findNext((ShardsIterator)this.shardsIt.get(this.shardIndex), TransportFieldCapabilitiesIndexAction.this.clusterService.state(), failure, this::moveToNextShard);
            if (next != null) {
                return next;
            }
            this.moveToNextShard();
            return this.nextRoutingOrNull(failure);
        }

        private void moveToNextShard() {
            ++this.shardIndex;
        }

        private void tryNext(@Nullable Exception lastFailure, boolean canMatchShard) {
            final ShardRouting shardRouting = this.nextRoutingOrNull(lastFailure);
            if (shardRouting == null) {
                if (!canMatchShard) {
                    this.listener.onResponse((Object)new FieldCapabilitiesIndexResponse(this.request.index(), Collections.emptyMap(), false));
                } else if (lastFailure == null || TransportActions.isShardNotAvailableException((Throwable)lastFailure)) {
                    this.listener.onFailure((Exception)new NoShardAvailableActionException(null, LoggerMessageFormat.format((String)"No shard available for [{}]", (Object[])new Object[]{this.request}), (Throwable)lastFailure));
                } else {
                    logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", null, (Object)this.request), (Throwable)lastFailure);
                    this.listener.onFailure(lastFailure);
                }
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, (Exception)new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                this.request.shardId(shardRouting.shardId());
                if (logger.isTraceEnabled()) {
                    logger.trace("sending request [{}] on node [{}]", (Object)this.request, (Object)node);
                }
                TransportFieldCapabilitiesIndexAction.this.transportService.sendRequest(node, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, (TransportRequest)this.request, (TransportResponseHandler)new TransportResponseHandler<FieldCapabilitiesIndexResponse>(){

                    public FieldCapabilitiesIndexResponse read(StreamInput in) throws IOException {
                        return new FieldCapabilitiesIndexResponse(in);
                    }

                    public String executor() {
                        return "same";
                    }

                    public void handleResponse(FieldCapabilitiesIndexResponse response) {
                        if (response.canMatch()) {
                            AsyncShardsAction.this.listener.onResponse((Object)response);
                        } else {
                            AsyncShardsAction.this.moveToNextShard();
                            AsyncShardsAction.this.tryNext(null, false);
                        }
                    }

                    public void handleException(TransportException exp) {
                        AsyncShardsAction.this.onFailure(shardRouting, (Exception)exp);
                    }
                });
            }
        }
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return FieldCapabilitiesAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportFieldCapabilitiesAction.class;
        }

        public Class<?>[] getSupportTransportActions() {
            return new Class[]{TransportFieldCapabilitiesIndexAction.class};
        }
    }
}

