/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.action.get;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.RoutingMissingException;
import io.skylite.core.action.get.GetAction;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.spi.ActionProvider;
import io.skylite.core.action.support.TransportAction;
import io.skylite.core.action.support.single.shard.SingleShardRequest;
import io.skylite.core.action.support.single.shard.TransportSingleShardAction;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.routing.Preference;
import io.skylite.core.cluster.routing.ShardIterator;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.get.GetResult;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;

public class TransportGetAction
extends TransportSingleShardAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportGetAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/get", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetRequest::new, "get");
        this.indicesService = indicesService;
    }

    protected boolean resolveIndex(GetRequest request) {
        return true;
    }

    protected static boolean shouldForcePrimaryRouting(Metadata metadata, boolean realtime, String preference, String indexName) {
        return metadata.isSegmentReplicationEnabled(indexName) && realtime && preference == null;
    }

    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        String preference = TransportGetAction.shouldForcePrimaryRouting(state.getMetadata(), ((GetRequest)request.request()).realtime(), ((GetRequest)request.request()).preference(), request.concreteIndex()) ? Preference.PRIMARY.type() : ((GetRequest)request.request()).preference();
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), preference);
    }

    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((GetRequest)request.request()).routing(state.metadata().resolveIndexRouting(((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
        if (((GetRequest)request.request()).routing() == null && state.getMetadata().routingRequired(request.concreteIndex())) {
            throw new RoutingMissingException(request.concreteIndex(), ((GetRequest)request.request()).id());
        }
    }

    protected void asyncShardOperation(GetRequest request, ShardId shardId, ActionListener<GetResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
        } else {
            indexShard.awaitShardSearchActive(b -> {
                try {
                    super.asyncShardOperation((SingleShardRequest)request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    protected GetResponse shardOperation(GetRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_get");
        }
        GetResult result = indexShard.getService().get(request.id(), request.storedFields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext());
        return new GetResponse(result);
    }

    protected Writeable.Reader<GetResponse> getResponseReader() {
        return GetResponse::new;
    }

    protected String getExecutor(GetRequest request, ShardId shardId) {
        ClusterState clusterState = this.clusterService.state();
        if (clusterState.metadata().getIndexSafe(shardId.getIndex()).isSystem()) {
            return "system_read";
        }
        if (this.indicesService.indexServiceSafe(shardId.getIndex()).getIndexSettings().isSearchThrottled()) {
            return "search_throttled";
        }
        return super.getExecutor((SingleShardRequest)request, shardId);
    }

    public static final class ActionProviderImpl
    implements ActionProvider {
        public ActionType<? extends ActionResponse> getInstance() {
            return GetAction.INSTANCE;
        }

        public Class<? extends TransportAction<? extends ActionRequest, ? extends ActionResponse>> getTransportAction() {
            return TransportGetAction.class;
        }
    }
}

